/*
 * Decompiled with CFR 0.152.
 */
package ss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import ss.MainWindow;

public class PropertiesWorker {
    private static final String BASE_TEXT_IN_FILE = "This is a text file, encoding ISO-8859-1";
    private MainWindow main;
    private String filename;

    public PropertiesWorker(MainWindow main, String filename) {
        this.main = main;
        this.filename = filename;
    }

    public void updateSystemProperties() {
        Properties prop = new Properties();
        try {
            FileInputStream fis = new FileInputStream(new File(this.main.getDataFolder(), this.filename));
            prop.load(fis);
            for (Object okey : prop.keySet()) {
                String key = (String)okey;
                if (!key.startsWith("properties.")) continue;
                System.setProperty(key.substring("properties.".length()), (String)prop.get(key));
            }
        }
        catch (FileNotFoundException e) {
            try {
                FileWriter fos = new FileWriter(new File(this.main.getDataFolder(), this.filename));
                fos.write("This is a text file, encoding ISO-8859-1\n");
                fos.close();
            }
            catch (IOException ex) {
                this.main.showMessage(String.valueOf(this.main.getString("error", e)) + "\nCheck folder rights", true);
            }
            return;
        }
        catch (IOException e) {
            this.main.showMessage(this.main.getString("error", e), true);
            return;
        }
    }

    public synchronized String loadString(String key) {
        Properties prop = new Properties();
        try {
            FileInputStream fis = new FileInputStream(new File(this.main.getDataFolder(), this.filename));
            prop.load(fis);
            fis.close();
            return prop.getProperty(key);
        }
        catch (FileNotFoundException e) {
            this.main.showMessage(this.main.getString("error", e), true);
            return null;
        }
        catch (IOException e) {
            this.main.showMessage(this.main.getString("error", e), true);
            return null;
        }
    }

    public Integer loadInteger(String key) {
        String v = this.loadString(key);
        if (v == null) {
            return null;
        }
        Double d = new Double(v);
        return d.intValue();
    }

    public Float loadFloat(String key) {
        String v = this.loadString(key);
        if (v == null) {
            return null;
        }
        return new Float(v);
    }

    public Boolean loadBoolean(String key) {
        String v = this.loadString(key);
        if (v == null) {
            return null;
        }
        return new Boolean(v);
    }

    public Map<String, ?> loadMap(String key) {
        Object o = this.load(key);
        if (o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    public Object load(String key) {
        Properties prop = new Properties();
        try {
            FileInputStream fis = new FileInputStream(new File(this.main.getDataFolder(), this.filename));
            prop.load(fis);
            fis.close();
            Object o = PropertiesWorker.getObjectFromPropertiesListRec(key, prop);
            return o;
        }
        catch (FileNotFoundException e) {
            this.main.showMessage(this.main.getString("error", e), true);
            return null;
        }
        catch (IOException e) {
            this.main.showMessage(this.main.getString("error", e), true);
            return null;
        }
    }

    public String loadFirstTrue(String ... keys) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String v = this.loadString(key);
            if (v != null && new Boolean(v).booleanValue()) {
                return key;
            }
            ++n2;
        }
        return null;
    }

    public synchronized void save(String key, Object v) {
        Properties prop = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Enumeration<Object> keys() {
                ArrayList<Object> l = Collections.list(super.keys());
                Collections.sort(l, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((String)o1).compareTo((String)o2);
                    }
                });
                return Collections.enumeration(l);
            }
        };
        try {
            try {
                FileInputStream fis = new FileInputStream(new File(this.main.getDataFolder(), this.filename));
                prop.load(fis);
                fis.close();
            }
            catch (FileNotFoundException fis) {
                // empty catch block
            }
            prop.remove(key);
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String k = (String)e.nextElement();
                if (!k.startsWith(key) || k.length() <= key.length() || k.charAt(key.length()) != '.') continue;
                prop.remove(k);
            }
            if (v != null) {
                Map<String, String> lines = PropertiesWorker.getPropertiesListFromObjectRec(key, v);
                for (String detailKey : lines.keySet()) {
                    prop.put(detailKey, lines.get(detailKey));
                }
            }
            FileOutputStream fos = new FileOutputStream(new File(this.main.getDataFolder(), this.filename));
            prop.store(fos, BASE_TEXT_IN_FILE);
            fos.close();
        }
        catch (IOException e) {
            this.main.showMessage(this.main.getString("error", e), true);
        }
    }

    public void backup() throws IOException {
        this.copyFile(this.filename, String.valueOf(this.filename) + ".bak");
    }

    public void restore() throws IOException {
        this.copyFile(String.valueOf(this.filename) + ".bak", this.filename);
        new File(String.valueOf(this.filename) + ".bak").deleteOnExit();
    }

    private void copyFile(String inputFile, String outputFile) throws IOException {
        int c;
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static Map<String, String> getPropertiesListFromObjectRec(String baseKey, Object v) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (v instanceof Map) {
            for (String subkey : ((Map)v).keySet()) {
                res.putAll(PropertiesWorker.getPropertiesListFromObjectRec(String.valueOf(baseKey) + "." + subkey, ((Map)v).get(subkey)));
            }
        } else if (v instanceof Iterable) {
            int n = 0;
            for (Object subv : (Iterable)v) {
                res.putAll(PropertiesWorker.getPropertiesListFromObjectRec(String.valueOf(baseKey) + "." + n, subv));
                ++n;
            }
        } else {
            res.put(baseKey, String.valueOf(v));
        }
        return res;
    }

    public static Object getObjectFromPropertiesListRec(String baseKey, Properties prop) {
        Enumeration<?> e2;
        if (prop.containsKey(baseKey)) {
            String v = prop.getProperty(baseKey);
            try {
                return Integer.parseInt(v);
            }
            catch (Exception exception) {
                try {
                    return Float.valueOf(Float.parseFloat(v));
                }
                catch (Exception exception2) {
                    if (v.equalsIgnoreCase("true")) {
                        return true;
                    }
                    if (v.equalsIgnoreCase("false")) {
                        return false;
                    }
                    if (v.equalsIgnoreCase("null")) {
                        return null;
                    }
                    return v;
                }
            }
        }
        boolean isArray = false;
        boolean isMap = false;
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            if (!k.startsWith(baseKey) || k.length() <= baseKey.length() || k.charAt(baseKey.length()) != '.') continue;
            String kSubstr = k.substring(baseKey.length() + 1);
            if (kSubstr.matches("^\\d{1,3}.*") && !isMap) {
                isArray = true;
                break;
            }
            isMap = true;
            break;
        }
        if (isArray) {
            ArrayList<Object> l = new ArrayList<Object>();
            e2 = prop.propertyNames();
            while (e2.hasMoreElements()) {
                String k = (String)e2.nextElement();
                if (!k.startsWith(baseKey) || k.length() <= baseKey.length() || k.charAt(baseKey.length()) != '.') continue;
                String baseSubkey = k;
                if (baseSubkey.substring(baseKey.length() + 1).contains(".")) {
                    baseSubkey = baseSubkey.substring(0, baseSubkey.indexOf(".", baseKey.length() + 1));
                }
                String midKey = baseSubkey.substring(baseKey.length() + 1);
                int num = Integer.parseInt(midKey);
                while (num >= l.size()) {
                    l.add(null);
                }
                l.set(num, PropertiesWorker.getObjectFromPropertiesListRec(baseSubkey, prop));
            }
            return l;
        }
        if (isMap) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            e2 = prop.propertyNames();
            while (e2.hasMoreElements()) {
                String k = (String)e2.nextElement();
                if (!k.startsWith(baseKey) || k.length() <= baseKey.length() || k.charAt(baseKey.length()) != '.') continue;
                String baseSubkey = k;
                if (baseSubkey.substring(baseKey.length() + 1).contains(".")) {
                    baseSubkey = baseSubkey.substring(0, baseSubkey.indexOf(".", baseKey.length() + 1));
                }
                String midKey = baseSubkey.substring(baseKey.length() + 1);
                m.put(midKey, PropertiesWorker.getObjectFromPropertiesListRec(baseSubkey, prop));
            }
            return m;
        }
        return null;
    }
}

