/*
 * Decompiled with CFR 0.152.
 */
package ss;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ss.IScript;
import ss.MainWindow;
import ss.WebCommunicator;

public class ScriptContainer {
    public static final String TEMP_NAME = "TemporaryUnnamedScript";
    public IScript currentScript;
    public String currentScriptFileName;
    public String currentScriptText;
    public boolean forgetScriptAtEnd;
    private List<String> usedFiles;
    public int savedVersion;
    public String savedTitle;
    public String savedSummary;
    public String savedAuthor;
    public String savedStatus;
    public int savedColor;
    public String savedLang;
    public List<String> savedTags;

    public void update(int version, String title, String summary, String author, String status, int color, String lang, List<String> tags) {
        this.savedVersion = version;
        this.savedTitle = title;
        this.savedSummary = summary;
        this.savedAuthor = author;
        this.savedStatus = status;
        this.savedColor = color;
        this.savedLang = lang;
        this.savedTags = tags;
    }

    public String getScriptClassText(boolean testing) {
        try {
            String line;
            String miniCurrentScriptName = this.getMiniCurrentScriptName();
            if (miniCurrentScriptName == null) {
                miniCurrentScriptName = TEMP_NAME;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/ss/FullScript.groovytemplate")));
            String fullScript = "";
            while ((line = br.readLine()) != null) {
                String transformedScriptText = this.currentScriptText.replaceAll("(\\W)wait\\s*\\(", "$1replacedByWait(");
                line = line.replace("/*scriptText*/", transformedScriptText);
                line = line.replace("/*scriptNameKeys*/", miniCurrentScriptName.replace("/", "."));
                line = line.replace("/*scriptNameJava*/", this.getMiniCurrentScriptNameJava());
                line = testing ? line.replace("/*scriptParentClass*/", "ss.desktop.ScriptStub") : (this.getMachine() == Machine.Android ? line.replace("/*scriptParentClass*/", "ss.android.Script") : line.replace("/*scriptParentClass*/", "ss.desktop.Script"));
                fullScript = String.valueOf(fullScript) + line + "\n";
            }
            br.close();
            return fullScript;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getMiniCurrentScriptNameJava() {
        String miniCurrentScriptName = this.getMiniCurrentScriptName();
        if (miniCurrentScriptName == null) {
            miniCurrentScriptName = TEMP_NAME;
        }
        return miniCurrentScriptName.replace("/", "_").replaceAll("[^a-zA-Z0-9_]", "");
    }

    public String getMiniCurrentScriptName() {
        if (this.currentScriptFileName == null) {
            return null;
        }
        String res = this.currentScriptFileName;
        if ((res = res.replace("\\", "/")).contains("scripts/")) {
            res = res.substring(res.lastIndexOf("scripts/") + "scripts/".length());
        } else if (res.contains("/")) {
            res = res.substring(res.lastIndexOf("/") + 1);
        }
        if (res.contains(".")) {
            res = res.substring(0, res.indexOf("."));
        }
        if (res.contains("_") && res.lastIndexOf("_") > res.length() - 4) {
            res = res.substring(0, res.lastIndexOf("_"));
        }
        return res;
    }

    public void readFromFile() throws IOException {
        String line;
        this.currentScriptText = "";
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.currentScriptFileName), Charset.forName("UTF8")));
        while ((line = br.readLine()) != null) {
            this.currentScriptText = String.valueOf(this.currentScriptText) + line + "\n";
        }
        br.close();
        if (this.currentScriptText.startsWith(new String(new byte[]{-17, -69, -65})) || this.currentScriptText.getBytes()[0] == 63 || this.currentScriptText.getBytes()[0] == 0) {
            this.currentScriptText = this.currentScriptText.substring(1);
        }
    }

    public void askForAndImportScript(MainWindow main, String defaultString) {
        try {
            String url = main.getInputString(main.getString("import.url", new Object[0]), defaultString);
            if (url != null) {
                Object[] importResult = this.importScript(main, url);
                int nbGroovy = (Integer)importResult[0];
                String firstName = (String)importResult[1];
                if (nbGroovy == 1) {
                    main.showMessage(main.getString("import.ok", nbGroovy, " " + firstName), false);
                } else {
                    main.showMessage(main.getString("import.ok", nbGroovy, ""), false);
                }
            }
        }
        catch (Exception e) {
            String message = e.toString();
            if (message.contains("429")) {
                message = String.valueOf(message) + " (download quotas)";
            }
            main.showMessage(main.getString("error", message), true);
        }
        main.setWaiting(false);
    }

    public Object[] importScript(MainWindow main, String url) throws IOException, MalformedURLException, FileNotFoundException {
        ZipEntry ze;
        main.setWaiting(true);
        if (!url.contains("://")) {
            if (!url.startsWith("/")) {
                url = "/" + url;
            }
            url = "https://ss.deviatenow.com" + url;
        }
        URLConnection conn = null;
        if (url.startsWith("http")) {
            WebCommunicator webCommunicator = new WebCommunicator();
            boolean noMoreRedirects = false;
            int redirects = 0;
            HttpURLConnection httpConn = null;
            while (!noMoreRedirects && redirects < 16) {
                httpConn = webCommunicator.getConnection(url);
                noMoreRedirects = true;
                if (httpConn.getResponseCode() != 301 && httpConn.getResponseCode() != 302 && httpConn.getResponseCode() != 303) continue;
                url = httpConn.getHeaderField("Location");
                noMoreRedirects = false;
                ++redirects;
            }
            conn = httpConn;
        } else {
            conn = new URL(url).openConnection();
        }
        ZipInputStream zip = new ZipInputStream(conn.getInputStream());
        int nbGroovy = 0;
        String firstName = null;
        while ((ze = zip.getNextEntry()) != null) {
            int o;
            File f = new File(main.getDataFolder(), ze.getName());
            if (ze.isDirectory()) {
                f.mkdirs();
                continue;
            }
            boolean savePrevious = f.exists();
            File pf = null;
            if (savePrevious) {
                File pfd = new File(main.getDataFolder(), "previous");
                pf = new File(pfd, ze.getName());
                pf.getParentFile().mkdirs();
                FileInputStream fis = new FileInputStream(f);
                FileOutputStream fos = new FileOutputStream(pf);
                fos.getChannel().transferFrom(fis.getChannel(), 0L, fis.getChannel().size());
                fos.close();
                fis.close();
            }
            FileOutputStream fos = new FileOutputStream(f);
            while ((o = zip.read()) > -1) {
                fos.write(o);
            }
            fos.close();
            zip.closeEntry();
            if (savePrevious) {
                boolean same = true;
                if (f.length() != pf.length()) {
                    same = false;
                }
                if (same && f.length() < 20000L) {
                    FileInputStream fis1 = new FileInputStream(f);
                    FileInputStream fis2 = new FileInputStream(pf);
                    int v1 = 0;
                    while ((v1 = fis1.read()) != -1) {
                        int v2 = fis2.read();
                        if (v1 == v2) continue;
                        same = false;
                        break;
                    }
                    fis2.close();
                    fis1.close();
                }
                if (same) {
                    pf.delete();
                }
            }
            if (!ze.getName().endsWith(".groovy")) continue;
            ++nbGroovy;
            if (firstName != null) continue;
            firstName = ze.getName();
        }
        zip.close();
        return new Object[]{new Integer(nbGroovy), firstName};
    }

    public void clearUsedFiles() {
        this.usedFiles = new ArrayList<String>();
    }

    public void addToMainUsedFiles(String fileName) {
        String fullFileName;
        if (fileName != null && !this.usedFiles.contains(fullFileName = new File(fileName).getAbsolutePath().replace("\\.\\", "\\"))) {
            this.usedFiles.add(fullFileName);
        }
    }

    public List<String> getUsedFiles() {
        return this.usedFiles;
    }

    public Machine getMachine() {
        try {
            Class.forName("android.R");
            return Machine.Android;
        }
        catch (ClassNotFoundException e) {
            return Machine.Desktop;
        }
    }

    public static enum Machine {
        Desktop,
        Android;

    }
}

