/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import groovy.lang.GroovyClassLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import ss.MainWindow;
import ss.ScriptContainer;
import ss.TextSource;
import ss.desktop.CyberMistressImportator;
import ss.desktop.MainFrame;
import ss.desktop.MilovanaImportator;
import ss.desktop.PictureGalleryImportator;
import ss.desktop.Publisher;
import ss.desktop.Script;
import ss.desktop.ScriptStub;
import ss.desktop.Snippet;

public class EditorFrame
extends JFrame {
    private static final String INFO_ADDRESS_START_STR = "@ line";
    private static final long serialVersionUID = 1L;
    private static final int TESTS_NUMBER = 20;
    private static final int INVISIBLE_LINES_COUNT = 41;
    private static final Integer DEFAULT_WIDTH = 880;
    private static final Integer DEFAULT_HEIGHT = 680;
    private static final int AUTOSAVE_MINUTES = 10;
    private static final int MAX_TEST_DURATION_SECONDS = 5;
    private static final String TEMPLATE_FILENAME = "scripts/template.groovy";
    private static final String AUTOSAVE_FILENAME = "scripts/autosave.groovy";
    private MainFrame main;
    private JTextPane scriptTP;
    private JTextPane infoTP;
    private JTextField searchEdit;
    private JLabel infoLabel;
    private UndoManager undoManager;
    private int lastCaretDot;
    private SyntaxHighlighter syntaxHighlighter;
    private SortedMap<String, List<Snippet>> snippets;
    private java.util.Timer autoSaveTimer;
    private Thread testThread;
    private java.util.Timer stopTestTimer;
    private long stopTestTimerStart;
    private List<LinkPosition> linkPositions;
    private int assistLevel;

    public EditorFrame(MainFrame main) {
        this.main = main;
        Integer al = main.getPropertiesWorker().loadInteger("application.editor.assistlevel");
        this.assistLevel = al == null ? 255 : al;
        this.syntaxHighlighter = new SyntaxHighlighter();
        this.createMenu();
        this.createFrame();
        this.loadSnippetsAndCreateContextMenu();
        if ((this.assistLevel & 2) != 0) {
            this.syntaxHighlighter.fireChange(false);
        }
        SwingUtilities.invokeLater(this.syntaxHighlighter);
        this.startAutoSaveTimer();
    }

    protected void finalize() {
        this.autoSaveTimer.cancel();
        this.stopTestTimer.cancel();
    }

    public boolean isUnsaved() {
        return !this.scriptTP.getText().equals(this.main.getScriptContainer().currentScriptText);
    }

    private void createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu mFile = new JMenu(this.main.getString("menu.file", new Object[0]));
        mFile.setMnemonic('F');
        jMenuBar.add(mFile);
        JMenuItem mNew = new JMenuItem(this.main.getString("menu.new", new Object[0]), new ImageIcon(this.getClass().getResource("images/new.png")));
        mNew.setMnemonic('N');
        mNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(EditorFrame.this, EditorFrame.this.main.getString("warning.interrupt", new Object[0]), EditorFrame.this.main.getString("title", new Object[0]), 2) == 0) {
                    EditorFrame.this.createNewScript();
                }
            }
        });
        mFile.add(mNew);
        mFile.add(new JSeparator());
        JMenuItem mOpen = new JMenuItem(this.main.getString("menu.open", new Object[0]), new ImageIcon(this.getClass().getResource("images/open.png")));
        mOpen.setMnemonic('O');
        mOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.tryOpen();
            }
        });
        mFile.add(mOpen);
        JMenuItem mSave = new JMenuItem(this.main.getString("menu.save", new Object[0]), new ImageIcon(this.getClass().getResource("images/save.png")));
        mSave.setMnemonic('S');
        mSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        mSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.trySave();
            }
        });
        mFile.add(mSave);
        JMenuItem mSaveAs = new JMenuItem(this.main.getString("menu.save_as", new Object[0]), new ImageIcon(this.getClass().getResource("images/saveas.png")));
        mSaveAs.setMnemonic('A');
        mSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptContainer sc = EditorFrame.this.main.getScriptContainer();
                String oldName = sc.currentScriptFileName;
                sc.currentScriptFileName = null;
                EditorFrame.this.trySave();
                if (sc.currentScriptFileName == null) {
                    sc.currentScriptFileName = oldName;
                }
            }
        });
        mFile.add(mSaveAs);
        mFile.add(new JSeparator());
        JMenuItem mPictureGallery = new JMenuItem(this.main.getString("menu.picturegallery", new Object[0]), new ImageIcon(this.getClass().getResource("images/picturegallery.png")));
        mPictureGallery.setMnemonic('G');
        mPictureGallery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String res = new PictureGalleryImportator().doImport(EditorFrame.this.main, EditorFrame.this);
                if (res != null) {
                    EditorFrame.this.scriptTP.setText(String.valueOf(EditorFrame.this.scriptTP.getText()) + res);
                }
            }
        });
        mFile.add(mPictureGallery);
        JMenuItem mMilovana = new JMenuItem(this.main.getString("menu.milovana", new Object[0]), new ImageIcon(this.getClass().getResource("images/milovana.png")));
        mMilovana.setMnemonic('M');
        mMilovana.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String res = new MilovanaImportator().doImport(EditorFrame.this.main, EditorFrame.this);
                if (res != null) {
                    EditorFrame.this.scriptTP.setText(String.valueOf(EditorFrame.this.scriptTP.getText()) + res);
                }
            }
        });
        mFile.add(mMilovana);
        JMenuItem mCybermistress = new JMenuItem(this.main.getString("menu.cybermistress", new Object[0]), new ImageIcon(this.getClass().getResource("images/cybermistress.png")));
        mCybermistress.setMnemonic('C');
        mCybermistress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String res = new CyberMistressImportator().doImport(EditorFrame.this.main, EditorFrame.this);
                if (res != null) {
                    EditorFrame.this.scriptTP.setText(String.valueOf(EditorFrame.this.scriptTP.getText()) + res);
                }
            }
        });
        mFile.add(mCybermistress);
        mFile.add(new JSeparator());
        JMenuItem mPublish = new JMenuItem(this.main.getString("menu.publish", new Object[0]), new ImageIcon(this.getClass().getResource("images/publish.png")));
        mPublish.setMnemonic('P');
        mPublish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.trySave();
                new Publisher(EditorFrame.this, EditorFrame.this.main).execute();
            }
        });
        mFile.add(mPublish);
        mFile.add(new JSeparator());
        JMenuItem mClose = new JMenuItem(this.main.getString("menu.close", new Object[0]), new ImageIcon(this.getClass().getResource("images/exit.png")));
        mClose.setMnemonic('Q');
        mClose.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        mClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.tryDispose();
            }
        });
        mFile.add(mClose);
        JMenu mEdit = new JMenu(this.main.getString("menu.edit", new Object[0]));
        mEdit.setMnemonic('E');
        jMenuBar.add(mEdit);
        JMenuItem mUndo = new JMenuItem(String.valueOf(this.main.getString("menu.undo", new Object[0])) + " Ctrl+Z", new ImageIcon(this.getClass().getResource("images/undo.png")));
        mUndo.setMnemonic('U');
        mUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.undo();
            }
        });
        mUndo.setEnabled(false);
        mEdit.add(mUndo);
        JMenuItem mRedo = new JMenuItem(String.valueOf(this.main.getString("menu.redo", new Object[0])) + " Ctrl+Y", new ImageIcon(this.getClass().getResource("images/redo.png")));
        mRedo.setMnemonic('R');
        mRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.redo();
            }
        });
        mRedo.setEnabled(false);
        mEdit.add(mRedo);
        mEdit.add(new JSeparator());
        JMenuItem mSearch = new JMenuItem(this.main.getString("menu.search", new Object[0]), new ImageIcon(this.getClass().getResource("images/search.png")));
        mSearch.setMnemonic('e');
        mSearch.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        mSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.searchNext(false);
            }
        });
        mEdit.add(mSearch);
        JMenuItem mReplace = new JMenuItem(this.main.getString("menu.replace", new Object[0]), new ImageIcon(this.getClass().getResource("images/replace.png")));
        mReplace.setMnemonic('R');
        mReplace.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        mReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.replaceAll();
            }
        });
        mEdit.add(mReplace);
        mEdit.add(new JSeparator());
        JMenuItem mCut = new JMenuItem(this.main.getString("menu.cut", new Object[0]), new ImageIcon(this.getClass().getResource("images/cut.png")));
        mCut.setMnemonic('C');
        mCut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        mCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.cutScript(e);
            }
        });
        mEdit.add(mCut);
        JMenuItem mCopy = new JMenuItem(this.main.getString("menu.copy", new Object[0]), new ImageIcon(this.getClass().getResource("images/copy.png")));
        mCopy.setMnemonic('P');
        mCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        mCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.copyScript();
            }
        });
        mEdit.add(mCopy);
        JMenuItem mPaste = new JMenuItem(this.main.getString("menu.paste", new Object[0]), new ImageIcon(this.getClass().getResource("images/paste.png")));
        mPaste.setMnemonic('O');
        mPaste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        mPaste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.pasteScript();
            }

            private void pasteScript() {
                Clipboard clipboard = EditorFrame.this.getToolkit().getSystemClipboard();
                try {
                    EditorFrame.this.scriptTP.getDocument().remove(EditorFrame.this.scriptTP.getSelectionStart(), EditorFrame.this.scriptTP.getSelectionEnd() - EditorFrame.this.scriptTP.getSelectionStart());
                    EditorFrame.this.scriptTP.getDocument().insertString(EditorFrame.this.scriptTP.getSelectionStart(), (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor), null);
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
        });
        mEdit.add(mPaste);
        JMenu mHelp = new JMenu(this.main.getString("menu.help", new Object[0]));
        mHelp.setMnemonic('H');
        jMenuBar.add(mHelp);
        JMenuItem mTest = new JMenuItem(this.main.getString("menu.check", new Object[0]), new ImageIcon(this.getClass().getResource("images/check.png")));
        mTest.setMnemonic('C');
        mTest.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        mTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.test();
            }
        });
        mHelp.add(mTest);
        JMenuItem mOnlineHelp = new JMenuItem(this.main.getString("menu.onlinehelp", new Object[0]), new ImageIcon(this.getClass().getResource("images/onlinehelp.png")));
        mOnlineHelp.setMnemonic('O');
        mOnlineHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.main.showOnlineHelp();
            }
        });
        mHelp.add(mOnlineHelp);
        mHelp.add(new JSeparator());
        JMenuItem mAbout = new JMenuItem(this.main.getString("menu.about", new Object[0]), new ImageIcon(this.getClass().getResource("images/about.png")));
        mAbout.setMnemonic('A');
        mAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.main.showAbout();
            }
        });
        mHelp.add(mAbout);
    }

    private void createFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditorFrame.this.tryDispose();
            }
        });
        this.setIconImage(this.main.getIconImage());
        JPanel upPane = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        JButton open = new JButton(this.main.getString("menu.open", new Object[0]), new ImageIcon(this.getClass().getResource("images/open.png")));
        open.setToolTipText(this.main.getString("menu.open.tooltip", new Object[0]));
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.tryOpen();
            }
        });
        jToolBar.add(open);
        JButton save = new JButton(this.main.getString("menu.save", new Object[0]), new ImageIcon(this.getClass().getResource("images/save.png")));
        save.setToolTipText(this.main.getString("menu.save.tooltip", new Object[0]));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.trySave();
            }
        });
        jToolBar.add(save);
        jToolBar.add(new JToolBar.Separator());
        JButton check = new JButton(this.main.getString("menu.check", new Object[0]), new ImageIcon(this.getClass().getResource("images/check.png")));
        check.setToolTipText(this.main.getString("menu.check.tooltip", new Object[0]));
        check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorFrame.this.test();
            }
        });
        jToolBar.add(check);
        jToolBar.add(new JToolBar.Separator());
        this.infoLabel = new JLabel("0/0");
        this.infoLabel.setHorizontalAlignment(0);
        this.infoLabel.setPreferredSize(new Dimension(50, this.infoLabel.getPreferredSize().height));
        jToolBar.add(this.infoLabel);
        jToolBar.add(new JToolBar.Separator());
        JLabel searchLabel = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/search.png"))));
        searchLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        jToolBar.add(searchLabel);
        this.searchEdit = new JTextField();
        this.searchEdit.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                EditorFrame.this.search(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        jToolBar.add(this.searchEdit);
        upPane.add((Component)jToolBar, "First");
        this.scriptTP = new JTextPane();
        this.scriptTP.setAutoscrolls(true);
        this.scriptTP.setFont(Font.getFont("monospaced"));
        this.scriptTP.setCursor(new Cursor(2));
        TabStop[] tabs = new TabStop[50];
        int i = 0;
        while (i < tabs.length) {
            tabs[i] = new TabStop((i + 1) * 29, 0, 0);
            ++i;
        }
        TabSet tabset = new TabSet(tabs);
        StyleContext sco = StyleContext.getDefaultStyleContext();
        AttributeSet aset = sco.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.TabSet, tabset);
        this.scriptTP.setParagraphAttributes(aset, false);
        ScriptContainer sc = this.main.getScriptContainer();
        if (sc.currentScriptText.equals("")) {
            this.createNewScript();
        }
        this.setText(sc.currentScriptText);
        this.scriptTP.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                EditorFrame.this.caretUpdate(ce);
            }
        });
        this.scriptTP.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9 && EditorFrame.this.scriptTPtabPressed((e.getModifiersEx() & 0x40) > 0)) {
                    e.consume();
                }
            }
        });
        JScrollPane scriptScroll = new JScrollPane(this.scriptTP);
        upPane.add(scriptScroll);
        this.infoTP = new JTextPane();
        this.infoTP.setAutoscrolls(true);
        this.infoTP.setEditable(false);
        this.infoTP.setToolTipText(this.main.getString("editor.info.tooltip", new Object[0]));
        this.infoTP.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int pos = EditorFrame.this.infoTP.viewToModel(e.getPoint());
                if (EditorFrame.this.linkPositions != null) {
                    for (LinkPosition lp : EditorFrame.this.linkPositions) {
                        if (pos <= lp.start || pos >= lp.end) continue;
                        String[] lines = EditorFrame.this.scriptTP.getText().split("\n");
                        int startSel = 0;
                        int endSel = 0;
                        int line = lp.line;
                        if (line < 0) {
                            line = 0;
                        } else if (line >= lines.length) {
                            line = lines.length - 1;
                        }
                        int i = 0;
                        while (i < line) {
                            startSel += lines[i].length() + 1;
                            ++i;
                        }
                        endSel = startSel + lines[line].length();
                        EditorFrame.this.scriptTP.setSelectionStart(startSel);
                        EditorFrame.this.scriptTP.setSelectionEnd(endSel);
                        EditorFrame.this.scriptTP.requestFocus();
                    }
                }
            }
        });
        JScrollPane infoScroll = new JScrollPane(this.infoTP);
        JSplitPane panel = new JSplitPane(0, upPane, infoScroll);
        this.setContentPane(panel);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                if ((e.getID() & 0x191) != 0) {
                    if (e.getKeyCode() == 70 && e.isControlDown()) {
                        EditorFrame.this.searchEdit.requestFocus();
                        EditorFrame.this.searchEdit.selectAll();
                        return true;
                    }
                    if (e.getKeyCode() == 114 && e.isShiftDown()) {
                        EditorFrame.this.searchNext(true);
                        return true;
                    }
                    if (e.getKeyCode() == 85 && e.isControlDown()) {
                        if (EditorFrame.this.isActive()) {
                            EditorFrame.this.main.setVisible(true);
                        }
                        return true;
                    }
                    if (e.getKeyCode() == 90 && e.isControlDown() && EditorFrame.this.undoManager.canUndo()) {
                        EditorFrame.this.undo();
                        return true;
                    }
                    if (e.getKeyCode() == 89 && e.isControlDown() && EditorFrame.this.undoManager.canRedo()) {
                        EditorFrame.this.redo();
                        return true;
                    }
                }
                return false;
            }
        });
        this.pack();
        Integer width = this.main.getPropertiesWorker().loadInteger("application.editor.width");
        Integer height = this.main.getPropertiesWorker().loadInteger("application.editor.height");
        Integer left = this.main.getPropertiesWorker().loadInteger("application.editor.left");
        Integer top = this.main.getPropertiesWorker().loadInteger("application.editor.top");
        if (width == null) {
            width = DEFAULT_WIDTH;
        }
        if (height == null) {
            height = DEFAULT_HEIGHT;
        }
        if (left == null || top == null) {
            this.setSize(width, height);
            this.setLocationRelativeTo(null);
        } else {
            this.setBounds(left, top, width, height);
        }
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                EditorFrame.this.saveSizeAndPosition();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                EditorFrame.this.saveSizeAndPosition();
            }
        });
        this.setVisible(true);
        panel.setDividerLocation(0.7);
    }

    protected void saveSizeAndPosition() {
        if (this.getState() == 0) {
            this.main.getPropertiesWorker().save("application.editor.width", this.getWidth());
            this.main.getPropertiesWorker().save("application.editor.height", this.getHeight());
            this.main.getPropertiesWorker().save("application.editor.left", this.getX());
            this.main.getPropertiesWorker().save("application.editor.top", this.getY());
        }
    }

    private void loadSnippetsAndCreateContextMenu() {
        ResourceBundle bundle = ResourceBundle.getBundle("snippets");
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        ArrayList<String> sortedKeys = Collections.list(bundle.getKeys());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            String[] parts = key.split("\\.");
            if (!names.contains(parts[1])) {
                names.add(parts[1]);
            }
            if (!parts[2].equals("group") || groups.contains(bundle.getString(key))) continue;
            groups.add(bundle.getString(key));
        }
        this.snippets = new TreeMap<String, List<Snippet>>();
        for (String group : groups) {
            ArrayList<Snippet> l = new ArrayList<Snippet>();
            for (String key : sortedKeys) {
                String[] parts = key.split("\\.");
                if (!parts[2].equals("group") || !bundle.getString(key).equals(group)) continue;
                l.add(new Snippet(parts[1], bundle.getString("snippets." + parts[1] + ".name"), bundle.getString("snippets." + parts[1] + ".text")));
            }
            this.snippets.put(group, l);
        }
        this.scriptTP.addMouseListener(new MouseListener(){

            public void popMenu(MouseEvent e) {
                JPopupMenu jpm = new JPopupMenu();
                for (String group : EditorFrame.this.snippets.keySet()) {
                    JMenu jmi = new JMenu(group);
                    boolean barDone = false;
                    for (Snippet sn : (List)EditorFrame.this.snippets.get(group)) {
                        JMenuItem jmis = new JMenuItem(sn.getName());
                        jmis.addActionListener(new ActionListener(){
                            private Snippet sn;

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                EditorFrame.this.useSnippet(this.sn);
                            }

                            public ActionListener init(Snippet sn) {
                                this.sn = sn;
                                return this;
                            }
                        }.init(sn));
                        if (sn.getKeyName().startsWith("z") && !barDone) {
                            jmi.add(new JSeparator(0));
                            barDone = true;
                        }
                        jmi.add(jmis);
                    }
                    jpm.add(jmi);
                }
                jpm.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popMenu(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    private void createNewScript() {
        this.main.stopScriptThreads();
        this.main.hideScriptInteractionComponents();
        ScriptContainer sc = this.main.getScriptContainer();
        sc.forgetScriptAtEnd = false;
        this.main.readScript(TEMPLATE_FILENAME);
        sc.currentScriptFileName = null;
        this.main.updateMenu();
        this.restartUndoRedo();
    }

    private boolean isCanQuitPerhapsSave() {
        if (this.isUnsaved()) {
            int res = JOptionPane.showConfirmDialog(this, this.main.getString("closing_save", new Object[0]), this.main.getString("title", new Object[0]), 1);
            if (res == 0) {
                this.trySave();
            }
            return res == 0 || res == 1;
        }
        return true;
    }

    private void tryDispose() {
        if (this.isCanQuitPerhapsSave()) {
            this.dispose();
        }
    }

    private void tryOpen() {
        if (!this.isCanQuitPerhapsSave()) {
            return;
        }
        File dstFile = this.main.getFileFromChooser(true, new File("scripts/"), null, this);
        if (dstFile != null) {
            this.main.stopScriptThreads();
            this.main.hideScriptInteractionComponents();
            ScriptContainer sc = this.main.getScriptContainer();
            sc.forgetScriptAtEnd = false;
            sc.savedAuthor = null;
            try {
                this.setText(this.main.readScript(dstFile.getCanonicalPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.startAutoSaveTimer();
        }
    }

    private void trySave() {
        String name = null;
        ScriptContainer sc = this.main.getScriptContainer();
        if (sc.currentScriptFileName == null) {
            File dstFile = this.main.getFileFromChooser(true, new File("scripts/"), null, this);
            if (dstFile != null) {
                sc.currentScriptText = this.scriptTP.getText();
                try {
                    name = dstFile.getCanonicalPath();
                }
                catch (IOException iOException) {}
            }
        } else {
            sc.currentScriptText = this.scriptTP.getText();
            name = sc.currentScriptFileName;
        }
        if (name != null) {
            this.main.writeScript(name, true);
            name = sc.currentScriptFileName;
            DateFormat df = DateFormat.getTimeInstance();
            this.addInfo(String.valueOf(df.format(new Date())) + " " + this.main.getString("menu.save", new Object[0]) + " " + name);
        }
    }

    private void startAutoSaveTimer() {
        if (this.autoSaveTimer != null) {
            this.autoSaveTimer.cancel();
        }
        this.autoSaveTimer = new java.util.Timer();
        if ((this.assistLevel & 1) != 0) {
            this.autoSaveTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    EditorFrame.this.autoSave();
                }
            }, 600000L, 600000L);
        }
    }

    private void autoSave() {
        this.main.getScriptContainer().currentScriptText = this.scriptTP.getText();
        this.main.writeScript(AUTOSAVE_FILENAME, false);
    }

    private void test() {
        this.testThread = new Thread(){

            @Override
            public void run() {
                EditorFrame.this.threadedTest();
            }
        };
        if (this.stopTestTimer != null) {
            this.stopTestTimer.cancel();
        }
        this.stopTestTimer = new java.util.Timer();
        this.stopTestTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (EditorFrame.this.testThread.isAlive()) {
                    EditorFrame.this.testThread.stop();
                    try {
                        EditorFrame.this.main.getPropertiesWorker().restore();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    DateFormat df = DateFormat.getTimeInstance();
                    EditorFrame.this.addInfo(String.valueOf(df.format(new Date())) + " " + EditorFrame.this.main.getString("parsing.stopped", new Object[0]));
                }
            }
        }, 5000L);
        this.stopTestTimerStart = System.currentTimeMillis();
        this.testThread.start();
    }

    /*
     * Unable to fully structure code
     */
    private void threadedTest() {
        block9: {
            df = DateFormat.getTimeInstance();
            this.addInfo(String.valueOf(df.format(new Date())) + " " + this.main.getString("parsing.start", new Object[0]));
            gcl = new GroovyClassLoader();
            statDelays = new ArrayList<Integer>();
            sc = this.main.getScriptContainer();
            sc.currentScriptText = this.scriptTP.getText();
            try {
                gcl.parseClass(sc.getScriptClassText(false));
                fullScript = sc.getScriptClassText(true);
                this.main.getScriptContainer().clearUsedFiles();
                sc.addToMainUsedFiles(sc.currentScriptFileName);
                c = gcl.parseClass(fullScript);
                this.main.getPropertiesWorker().backup();
                this.main.getPropertiesWorker().restore();
                this.main.getPropertiesWorker().backup();
                seed = 0;
                while (seed < 20 && (double)System.currentTimeMillis() < (double)this.stopTestTimerStart + 2500.0) {
                    sStub = (ScriptStub)c.getConstructor(new Class[]{MainWindow.class, TextSource.class, Long.TYPE}).newInstance(new Object[]{this.main, this.main, seed});
                    sStub.run();
                    statDelays.add(sStub.getStatDelay());
                    ++seed;
                }
                this.main.getPropertiesWorker().restore();
                gcl.close();
                break block9;
            }
            catch (Exception e) {
                try {
                    this.main.getPropertiesWorker().restore();
                }
                catch (IOException c) {
                    // empty catch block
                }
                s = this.main.getString("parsing.error", new Object[]{e.toString()});
                var10_16 = e.getStackTrace();
                var9_17 = var10_16.length;
                var8_15 = 0;
                ** while (var8_15 < var9_17)
            }
lbl-1000:
            // 1 sources

            {
                ste = var10_16[var8_15];
                if (ste.getClassName().equals("ss.ScriptStub") != false && ste.getMethodName().equals("run") != false || ste.getClassName().startsWith("ss.FullScript_") != false && ste.getMethodName().equals("run") != false || ste.getClassName().startsWith("ss.FullScript_") && ste.getMethodName().equals("doCall")) {
                    s = String.valueOf(s) + "(@ line " + ste.getLineNumber() + ")";
                    break;
                }
                ++var8_15;
                continue;
            }
lbl46:
            // 2 sources

            this.addInfo(s);
            e.printStackTrace();
        }
        Collections.sort(statDelays);
        medianTime = 0;
        if (statDelays.size() > 0) {
            n = 0;
            i = statDelays.size() / 5;
            while (i < statDelays.size() * 4 / 5) {
                medianTime += ((Integer)statDelays.get(i)).intValue();
                ++n;
                ++i;
            }
            medianTime = (int)Math.round((double)medianTime / 60.0 / (double)n);
        }
        this.addInfo(String.valueOf(df.format(new Date())) + " " + this.main.getString("parsing.end", new Object[]{medianTime}));
    }

    public void addInfo(String s) {
        this.infoTP.setText(String.valueOf(this.infoTP.getText()) + "\n" + s);
        StyledDocument sd = this.infoTP.getStyledDocument();
        SimpleAttributeSet nullAS = new SimpleAttributeSet();
        StyleConstants.setFontSize(nullAS, 12);
        SimpleAttributeSet addressAS = new SimpleAttributeSet();
        StyleConstants.setUnderline(addressAS, true);
        StyleConstants.setForeground(addressAS, new Color(0, 0, 128));
        sd.setCharacterAttributes(0, sd.getLength(), nullAS, true);
        int i = 0;
        String text = "";
        try {
            text = sd.getText(0, sd.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.linkPositions = new ArrayList<LinkPosition>();
        while (i > -1) {
            if ((i = text.indexOf(INFO_ADDRESS_START_STR, i + 1)) <= -1) continue;
            int end = i + 1;
            while (end < text.length() && (text.charAt(end) < '0' || text.charAt(end) > '9')) {
                ++end;
            }
            while (end < text.length() && text.charAt(end) >= '0' && text.charAt(end) <= '9') {
                ++end;
            }
            if (end < text.length()) {
                sd.setCharacterAttributes(i, end - i, addressAS, false);
            }
            int line = 0;
            try {
                String sLineNumber = text.substring(text.lastIndexOf(" ", end) + 1, end);
                line = Integer.parseInt(sLineNumber) - 41 - 1;
                if (line >= 0) {
                    this.linkPositions.add(new LinkPosition(i, end, line));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            i = end;
        }
        this.infoTP.setCaretPosition(this.infoTP.getDocument().getLength());
    }

    public void setText(String text) {
        if (this.undoManager != null) {
            this.scriptTP.getDocument().removeUndoableEditListener(this.undoManager);
        }
        this.scriptTP.setText(text);
        this.restartUndoRedo();
    }

    public String getUrlContent(String urlStr) throws MalformedURLException, IOException {
        String line;
        String res = "";
        HttpURLConnection urlConnection = this.getHttpURLConnection(urlStr);
        BufferedReader dis = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        while ((line = dis.readLine()) != null) {
            res = String.valueOf(res) + line + "\n";
        }
        dis.close();
        return res;
    }

    public HttpURLConnection getHttpURLConnection(String urlStr) throws IOException {
        boolean redirect = false;
        int nbRedirect = 0;
        HttpURLConnection urlConnection = null;
        do {
            URL url = new URL(urlStr);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Accept-Language", "en-US,en;q=0.3");
            urlConnection.setRequestProperty("Accept-Encoding", "deflate");
            urlConnection.setRequestProperty("DNT", "1");
            urlConnection.setRequestProperty("Referer", urlStr);
            urlConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
            urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:52.9) Gecko/20100101 Firefox/" + String.format("%.2f", 10.0 + Math.random() * 60.0));
            if (nbRedirect < 16 && urlConnection.getResponseCode() == 302 || urlConnection.getResponseCode() == 301 || urlConnection.getResponseCode() == 303) {
                redirect = true;
                ++nbRedirect;
                urlStr = urlConnection.getHeaderField("Location").trim();
                continue;
            }
            redirect = false;
        } while (redirect);
        return urlConnection;
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.scriptTP.setCursor(cursor);
        this.infoTP.setCursor(cursor);
        this.searchEdit.setCursor(cursor);
    }

    private void updateMenu() {
        this.getJMenuBar().getMenu(1).getItem(0).setEnabled(this.undoManager.canUndo());
        this.getJMenuBar().getMenu(1).getItem(1).setEnabled(this.undoManager.canRedo());
        this.main.updateMenu();
    }

    private void restartUndoRedo() {
        if (this.undoManager != null) {
            this.scriptTP.getDocument().removeUndoableEditListener(this.undoManager);
        }
        this.undoManager = new UndoManager(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized boolean addEdit(UndoableEdit anEdit) {
                boolean res = true;
                res = super.addEdit(anEdit);
                EditorFrame.this.syntaxHighlighter.fireChange(false);
                EditorFrame.this.updateMenu();
                return res;
            }
        };
        this.scriptTP.getDocument().addUndoableEditListener(this.undoManager);
        this.updateMenu();
        this.syntaxHighlighter.fireChange(false);
    }

    private void undo() {
        this.undoManager.undo();
        this.updateMenu();
        this.syntaxHighlighter.fireChange(false);
    }

    private void redo() {
        this.undoManager.redo();
        this.updateMenu();
        this.syntaxHighlighter.fireChange(false);
    }

    private void search(KeyEvent e) {
        if (this.searchEdit.getText().length() == 0) {
            this.searchEdit.setBackground(Color.WHITE);
        } else if (this.scriptTP.getText().toLowerCase().contains(this.searchEdit.getText().toLowerCase())) {
            if (e.getKeyCode() == 10) {
                this.scriptTP.requestFocus();
            }
            this.scriptTP.setSelectionStart(this.scriptTP.getText().toLowerCase().indexOf(this.searchEdit.getText().toLowerCase()));
            this.scriptTP.setSelectionEnd(this.scriptTP.getText().toLowerCase().indexOf(this.searchEdit.getText().toLowerCase()) + this.searchEdit.getText().length());
            this.searchEdit.setBackground(Color.WHITE);
        } else {
            this.searchEdit.setBackground(Color.RED);
        }
    }

    private void searchNext(boolean reverse) {
        String sStr = this.searchEdit.getText().toLowerCase();
        String text = this.scriptTP.getText().toLowerCase();
        if (sStr.trim().isEmpty()) {
            this.searchEdit.requestFocus();
        } else {
            this.scriptTP.requestFocus();
            if (text.contains(sStr)) {
                this.searchEdit.setBackground(Color.WHITE);
                int pos = this.scriptTP.getCaretPosition();
                if (reverse) {
                    if (pos > 0 && text.substring(0, pos - 1).contains(sStr)) {
                        this.scriptTP.setSelectionStart(text.substring(0, pos - 1).lastIndexOf(sStr));
                        this.scriptTP.setSelectionEnd(text.substring(0, pos - 1).lastIndexOf(sStr) + sStr.length());
                    } else {
                        this.scriptTP.setSelectionStart(text.lastIndexOf(sStr));
                        this.scriptTP.setSelectionEnd(text.lastIndexOf(sStr) + sStr.length());
                    }
                } else if (pos < text.length() + 1 && text.substring(pos + 1).contains(sStr)) {
                    this.scriptTP.setSelectionStart(pos + 1 + text.substring(pos + 1).indexOf(sStr));
                    this.scriptTP.setSelectionEnd(pos + 1 + text.substring(pos + 1).indexOf(sStr) + sStr.length());
                } else {
                    this.scriptTP.setSelectionStart(text.indexOf(sStr));
                    this.scriptTP.setSelectionEnd(text.indexOf(sStr) + sStr.length());
                }
            } else {
                this.searchEdit.setBackground(Color.RED);
            }
        }
    }

    private void replaceAll() {
        String sStr = this.searchEdit.getText();
        if (sStr.trim().isEmpty()) {
            this.searchEdit.requestFocus();
        } else {
            String replaceBy = JOptionPane.showInputDialog(this.main.getString("editor.replace_with", sStr), (Object)sStr);
            if (replaceBy != null) {
                int n = 0;
                String s = this.scriptTP.getText();
                while (s.length() > 0 && s.contains(sStr)) {
                    s = s.substring(s.indexOf(sStr) + sStr.length());
                    ++n;
                }
                this.scriptTP.setText(this.scriptTP.getText().replace(sStr, replaceBy));
                this.addInfo(this.main.getString("editor.replaced", n));
            }
        }
    }

    private void cutScript(ActionEvent e) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(this.scriptTP.getSelectedText());
        clipboard.setContents(data, data);
        try {
            this.scriptTP.getDocument().remove(this.scriptTP.getSelectionStart(), this.scriptTP.getSelectionEnd() - this.scriptTP.getSelectionStart());
        }
        catch (BadLocationException e1) {
            System.out.println(e);
        }
    }

    private void copyScript() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(this.scriptTP.getSelectedText());
        clipboard.setContents(data, data);
    }

    protected boolean scriptTPtabPressed(boolean shiftPressed) {
        int realEnd = this.scriptTP.getSelectionEnd();
        if (this.scriptTP.getSelectedText() == null) {
            if (shiftPressed) {
                realEnd = this.scriptTP.getCaretPosition();
            } else {
                return false;
            }
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        boolean possible = true;
        try {
            int realStart = this.scriptTP.getSelectionStart();
            while (realStart > 0 && !this.scriptTP.getDocument().getText(realStart, 1).equals("\n")) {
                --realStart;
            }
            int n = realStart;
            while (n < realEnd) {
                if (n == 0 || this.scriptTP.getDocument().getText(n - 1, 1).equals("\n")) {
                    positions.add(n);
                    if (shiftPressed && !this.scriptTP.getDocument().getText(n, 1).equals("\t")) {
                        possible = false;
                    }
                }
                ++n;
            }
            if (possible) {
                int i;
                if (shiftPressed) {
                    i = positions.size() - 1;
                    while (i >= 0) {
                        this.scriptTP.getDocument().remove((Integer)positions.get(i), 1);
                        --i;
                    }
                } else {
                    i = positions.size() - 1;
                    while (i >= 0) {
                        this.scriptTP.getDocument().insertString((Integer)positions.get(i), "\t", null);
                        --i;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return true;
    }

    private void useSnippet(Snippet sn) {
        String text = this.scriptTP.getText();
        int newCaretPos = this.scriptTP.getCaretPosition();
        String snippetText = sn.getSnippet();
        newCaretPos = sn.getSnippet().contains("${cursor}") ? (newCaretPos += snippetText.indexOf("${cursor}")) : (newCaretPos += snippetText.length());
        snippetText = snippetText.replace("${cursor}", "");
        ScriptContainer sc = this.main.getScriptContainer();
        if (sc.currentScriptFileName != null) {
            snippetText = snippetText.replace("${scriptname}", sc.currentScriptFileName);
        }
        text = String.valueOf(text.substring(0, this.scriptTP.getCaretPosition())) + snippetText + text.substring(this.scriptTP.getCaretPosition());
        this.scriptTP.setText(text);
        this.scriptTP.setCaretPosition(newCaretPos);
        this.syntaxHighlighter.fireChange(false);
    }

    private void caretUpdate(CaretEvent ce) {
        int y = 0;
        int x = 0;
        char[] ct = this.scriptTP.getText().toCharArray();
        int n = 0;
        this.lastCaretDot = ce.getDot();
        char[] cArray = ct;
        int n2 = ct.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            if (n == this.lastCaretDot) break;
            ++x;
            ++n;
            if (c == '\n') {
                ++y;
                x = 0;
            }
            ++n3;
        }
        this.infoLabel.setText(String.valueOf(1 + y + 41) + " : " + (1 + x));
        this.syntaxHighlighter.fireChange(true);
    }

    public String getClipboardUrl() {
        String res = "";
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        try {
            String content = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            String[] strings = content.split("\n");
            if (strings[0].contains("://")) {
                res = strings[0];
            }
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            // empty catch block
        }
        return res;
    }

    private class LinkPosition {
        public int start;
        public int end;
        public int line;

        public LinkPosition(int start, int end, int line) {
            this.start = start;
            this.end = end;
            this.line = line;
        }
    }

    private class SyntaxHighlighter
    implements Runnable {
        private static final int TIMER_MS = 200;
        private static final int SLOW_CODEASSIST_THRESHOLD_MS = 500;
        private int eventLevel = 0;
        private int timesToWait = 0;

        private SyntaxHighlighter() {
        }

        public void fireChange(boolean onlyCaret) {
            this.timesToWait = 1;
            this.eventLevel = onlyCaret ? 1 : 2;
        }

        @Override
        public void run() {
            if (this.timesToWait > 0) {
                --this.timesToWait;
            } else {
                if (this.eventLevel >= 2 && (EditorFrame.this.assistLevel & 0x38) != 0) {
                    this.updateFromModification();
                }
                if (this.eventLevel >= 1 && (EditorFrame.this.assistLevel & 4) != 0) {
                    this.updateFromCaretMove();
                }
                this.eventLevel = 0;
            }
            Timer t = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SyntaxHighlighter.this.run();
                }
            });
            t.setRepeats(false);
            t.start();
        }

        public void updateFromModification() {
            boolean tooSlow;
            int n;
            long startTime = System.currentTimeMillis();
            String[] keywords = new String[]{"abstract", "as", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "def", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "threadsafe", "throw", "throws", "trait", "transient", "true", "try", "void", "volatile", "while"};
            ArrayList<String> methodNames = new ArrayList<String>();
            Method[] methodArray = Script.class.getMethods();
            int n2 = methodArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Method m = methodArray[n3];
                methodNames.add(m.getName());
                ++n3;
            }
            StyledDocument sd = EditorFrame.this.scriptTP.getStyledDocument();
            SimpleAttributeSet nullAS = new SimpleAttributeSet();
            SimpleAttributeSet keywordsAS = new SimpleAttributeSet();
            StyleConstants.setBold(keywordsAS, true);
            StyleConstants.setForeground(keywordsAS, new Color(16384100));
            SimpleAttributeSet methodsAS = new SimpleAttributeSet();
            StyleConstants.setBold(methodsAS, true);
            StyleConstants.setForeground(methodsAS, new Color(6553850));
            SimpleAttributeSet stringAS = new SimpleAttributeSet();
            StyleConstants.setForeground(stringAS, new Color(30840));
            SimpleAttributeSet commentsAS = new SimpleAttributeSet();
            StyleConstants.setForeground(commentsAS, new Color(35840));
            SimpleAttributeSet searchAS = new SimpleAttributeSet();
            StyleConstants.setBackground(searchAS, new Color(0xC8C8FF));
            String text = EditorFrame.this.scriptTP.getText();
            EditorFrame.this.scriptTP.getDocument().removeUndoableEditListener(EditorFrame.this.undoManager);
            sd.setCharacterAttributes(0, sd.getLength(), nullAS, true);
            if ((EditorFrame.this.assistLevel & 8) != 0) {
                String[] words;
                int n4 = 0;
                String[] stringArray = words = text.split("[^a-zA-Z0-9]");
                n = words.length;
                int n5 = 0;
                while (n5 < n) {
                    String word = stringArray[n5];
                    int l = word.length();
                    if (l > 1) {
                        String[] stringArray2 = keywords;
                        int n6 = keywords.length;
                        int n7 = 0;
                        while (n7 < n6) {
                            String keyword = stringArray2[n7];
                            if (word.equals(keyword)) {
                                sd.setCharacterAttributes(n4, l, keywordsAS, false);
                            }
                            ++n7;
                        }
                    }
                    if (l > 2) {
                        for (String methodName : methodNames) {
                            if (!word.equals(methodName)) continue;
                            sd.setCharacterAttributes(n4, l, methodsAS, false);
                        }
                    }
                    n4 += l + 1;
                    ++n5;
                }
            }
            if ((EditorFrame.this.assistLevel & 0x10) != 0) {
                String[] lines = text.split("\"");
                int n8 = 0;
                boolean inString = false;
                String[] stringArray = lines;
                int n9 = lines.length;
                n = 0;
                while (n < n9) {
                    String line = stringArray[n];
                    if (inString) {
                        sd.setCharacterAttributes(n8, line.length(), stringAS, false);
                    }
                    n8 += line.length() + 1;
                    if (!line.endsWith("\\")) {
                        inString = !inString;
                    }
                    ++n;
                }
                lines = text.split("\n");
                n8 = 0;
                stringArray = lines;
                n9 = lines.length;
                n = 0;
                while (n < n9) {
                    String line = stringArray[n];
                    if (line.indexOf("//") > -1 && (line.indexOf("//") == 0 || line.charAt(line.indexOf("//") - 1) != ':')) {
                        sd.setCharacterAttributes(n8 + line.indexOf("//"), line.length() - line.indexOf("//"), commentsAS, true);
                    }
                    n8 += line.length() + 1;
                    ++n;
                }
                lines = text.split("\\*/");
                n8 = 0;
                stringArray = lines;
                n9 = lines.length;
                n = 0;
                while (n < n9) {
                    String line = stringArray[n];
                    if (line.indexOf("/*") > -1) {
                        sd.setCharacterAttributes(n8 + line.indexOf("/*"), line.length() - line.indexOf("/*"), commentsAS, true);
                    }
                    n8 += line.length() + 1;
                    ++n;
                }
            }
            if ((EditorFrame.this.assistLevel & 0x20) != 0) {
                SimpleAttributeSet noPairAS = new SimpleAttributeSet();
                StyleConstants.setBackground(noPairAS, new Color(0xFFFFFF));
                sd.setCharacterAttributes(0, EditorFrame.this.scriptTP.getText().length(), noPairAS, false);
                String sText = EditorFrame.this.searchEdit.getText().trim().toLowerCase();
                String lText = text.toLowerCase();
                if (sText.length() > 1) {
                    int n10 = 0;
                    while (lText.substring(n10).contains(sText)) {
                        n10 += lText.substring(n10).indexOf(sText);
                        sd.setCharacterAttributes(n10, sText.length(), searchAS, false);
                        n10 += sText.length();
                    }
                }
            }
            EditorFrame.this.scriptTP.getDocument().addUndoableEditListener(EditorFrame.this.undoManager);
            long endTime = System.currentTimeMillis();
            long time = endTime - startTime;
            boolean bl = tooSlow = time > 500L;
            if (tooSlow) {
                if ((EditorFrame.this.assistLevel & 8) != 0) {
                    EditorFrame editorFrame = EditorFrame.this;
                    editorFrame.assistLevel = editorFrame.assistLevel & 0xFFFFFFF7;
                    EditorFrame.this.addInfo("Code assist too slow (" + time + "ms > " + 500 + "ms), application.editor.assistlevel=" + EditorFrame.this.assistLevel + " applied (but not saved to data.properties)");
                } else if ((EditorFrame.this.assistLevel & 0x10) != 0) {
                    EditorFrame editorFrame = EditorFrame.this;
                    editorFrame.assistLevel = editorFrame.assistLevel & 0xFFFFFFEF;
                    EditorFrame.this.addInfo("Code assist too slow (" + time + "ms > " + 500 + "ms), application.editor.assistlevel=" + EditorFrame.this.assistLevel + " applied (but not saved to data.properties)");
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void updateFromCaretMove() {
            block14: {
                cars1 = new String[]{"(", "[", "{", ")", "]", "}"};
                cars2 = new String[]{")", "]", "}", "(", "[", "{"};
                try {
                    block15: {
                        block16: {
                            currentPos = EditorFrame.access$1(EditorFrame.this).getCaretPosition();
                            car = EditorFrame.access$1(EditorFrame.this).getText(currentPos, 1);
                            if (!Arrays.asList(cars1).contains(car) && currentPos > 0) {
                                car = EditorFrame.access$1(EditorFrame.this).getText(--currentPos, 1);
                            }
                            if (!Arrays.asList(cars1).contains(car)) break block14;
                            before = Arrays.asList(cars1).indexOf(car) >= cars1.length / 2;
                            otherCar = cars2[Arrays.asList(cars1).indexOf(car)];
                            foundPos = 0;
                            inclusionLevel = 0;
                            fulltext = EditorFrame.access$1(EditorFrame.this).getText();
                            p = currentPos;
                            if (!before) break block16;
                            text = fulltext.substring(0, p);
                            while (foundPos == 0 && p > 0) {
                                if (text.lastIndexOf(otherCar) == -1) break block15;
                                if (text.lastIndexOf(otherCar) <= text.lastIndexOf(car)) ** GOTO lbl26
                                if (inclusionLevel > 0) {
                                    --inclusionLevel;
                                    p = text.lastIndexOf(otherCar);
                                } else {
                                    foundPos = text.lastIndexOf(otherCar);
                                    break block15;
lbl26:
                                    // 1 sources

                                    if (text.lastIndexOf(otherCar) < text.lastIndexOf(car)) {
                                        ++inclusionLevel;
                                        p = text.lastIndexOf(car);
                                    }
                                }
                                text = text.substring(0, p);
                            }
                            break block15;
                        }
                        text = fulltext.substring(p + 1);
                        lostCars = p + 1;
                        while (foundPos == 0 && text.length() > 0) {
                            pOtherCar = text.indexOf(otherCar);
                            if (pOtherCar == -1) break;
                            if ((text.indexOf(car) != -1 || pOtherCar <= -1) && pOtherCar >= text.indexOf(car)) ** GOTO lbl45
                            if (inclusionLevel > 0) {
                                --inclusionLevel;
                                p = text.indexOf(otherCar);
                            } else {
                                foundPos = pOtherCar + lostCars;
                                break;
lbl45:
                                // 1 sources

                                if (text.indexOf(otherCar) > text.indexOf(car)) {
                                    ++inclusionLevel;
                                    p = text.indexOf(car);
                                }
                            }
                            text = text.substring(p + 1);
                            lostCars += p + 1;
                        }
                    }
                    EditorFrame.access$1(EditorFrame.this).getDocument().removeUndoableEditListener(EditorFrame.access$2(EditorFrame.this));
                    sd = EditorFrame.access$1(EditorFrame.this).getStyledDocument();
                    pairAS = new SimpleAttributeSet();
                    if (foundPos > 0) {
                        StyleConstants.setBackground(pairAS, new Color(0xFFFF78));
                    } else {
                        StyleConstants.setBackground(pairAS, new Color(0xFF7878));
                    }
                    sd.setCharacterAttributes(currentPos, 1, pairAS, false);
                    if (foundPos > 0) {
                        sd.setCharacterAttributes(foundPos, 1, pairAS, false);
                    }
                    EditorFrame.access$1(EditorFrame.this).getDocument().addUndoableEditListener(EditorFrame.access$2(EditorFrame.this));
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

