/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import ss.TextSource;
import ss.desktop.EditorFrame;

public abstract class Importator {
    public static final int PICTURE_MAX_WIDTH = 900;
    public static final int PICTURE_MAX_HEIGHT = 800;

    public abstract String doImport(TextSource var1, EditorFrame var2);

    public void resizeIfNeeded(File file) throws IOException {
        BufferedImage bi = ImageIO.read(file);
        int width = bi.getWidth();
        int height = bi.getHeight();
        boolean resize = false;
        if (width > 900) {
            height = height * 900 / width;
            width = 900;
            resize = true;
        }
        if (height > 800) {
            width = width * 900 / height;
            height = 900;
            resize = true;
        }
        if (resize) {
            Image rIm = bi.getScaledInstance(width, height, 4);
            BufferedImage rBi = new BufferedImage(width, height, bi.getType());
            rBi.createGraphics().drawImage(rIm, 0, 0, null);
            File newFile = file;
            if (!file.getName().toLowerCase().endsWith(".jpeg") && !file.getName().toLowerCase().endsWith(".jpg")) {
                String nameWOext = file.getAbsolutePath();
                nameWOext = nameWOext.substring(0, nameWOext.lastIndexOf("."));
                newFile = new File(String.valueOf(nameWOext) + ".jpeg");
            }
            ImageIO.write((RenderedImage)rBi, "JPEG", newFile);
        }
    }
}

