/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import groovy.lang.GroovyShell;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import ss.desktop.ArgumentParser;
import ss.desktop.MainFrame;

public class Main {
    public static final boolean DEBUG_MODE = false;

    public static void main(String[] args) {
        if (new ArgumentParser(args).containsKey("h") || new ArgumentParser(args).containsKey("help") || new ArgumentParser(args).containsKey("?")) {
            System.out.println("Usage : [command] [options] [script]\nOptions :\n-h|-help|-? : this help\n-s=zzz|-script=zzz : startup script\n-d=zzz|data=zzz : property file\n-t|-discreet : discreet mode\nExamples :\n./sexscript -h\n./sexscript intro\n./sexscript -s=intro -d=data2.properties");
        }
        if (!Main.quickTest()) {
            return;
        }
        Main.neuterConsole();
        Main.setLookAndFeel(true);
        new MainFrame(args);
    }

    private static void neuterConsole() {
        try {
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            }));
            System.setErr(new PrintStream(new OutputStream(){
                String s = "";

                @Override
                public void write(int b) throws IOException {
                    if (b >= 0) {
                        this.s = String.valueOf(this.s) + (char)b;
                    }
                    if ((char)b == '\n') {
                        if (this.s.contains("Exception") && !this.s.startsWith(" ") && !this.s.toLowerCase().contains("caused by")) {
                            this.s = String.valueOf(new Date().toString()) + "\n" + Main.getAdditionnalErrorMessage() + this.s + "\n";
                        }
                        FileWriter w = new FileWriter("errors.log", true);
                        w.write(this.s);
                        ((Writer)w).close();
                        this.s = "";
                    }
                }
            }));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean quickTest() {
        try {
            File f = new File("test");
            FileWriter w = new FileWriter(f);
            ((Writer)w).write(0);
            ((Writer)w).close();
            f.delete();
        }
        catch (Throwable e) {
            String eStr = e.toString();
            if (e.getCause() != null) {
                eStr = String.valueOf(eStr) + "\nCaused by : " + e.getCause().toString();
            }
            JOptionPane.showMessageDialog(null, "Error !\n" + eStr + "\n" + "Make sure you extracted the ZIP file, not running this " + "app from it, and writing to its directory is allowed.\n" + "Helpful system informations to resolve " + "it on the forum :\n" + Main.getAdditionnalErrorMessage() + "file.encoding : " + System.getProperty("file.encoding") + "\n" + "language : " + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry());
            return false;
        }
        try {
            new GroovyShell();
        }
        catch (Throwable e) {
            String eStr = e.toString();
            if (e.getCause() != null) {
                eStr = String.valueOf(eStr) + "\nCaused by : " + e.getCause().toString();
            }
            JOptionPane.showMessageDialog(null, "Groovy error !\n" + eStr + "\n" + "Helpful system informations to resolve " + "it on the forum :\n" + Main.getAdditionnalErrorMessage() + "file.encoding : " + System.getProperty("file.encoding") + "\n" + "language : " + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry());
            return false;
        }
        return true;
    }

    public static void setLookAndFeel(boolean toSystemLF) {
        try {
            String className = toSystemLF ? UIManager.getSystemLookAndFeelClassName() : "javax.swing.plaf.metal.MetalLookAndFeel";
            if (!UIManager.getLookAndFeel().getClass().getName().equals(className)) {
                UIManager.setLookAndFeel(className);
            }
        }
        catch (Exception ex) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            ex.printStackTrace();
        }
    }

    public static String getAdditionnalErrorMessage() {
        return "os.name : " + System.getProperty("os.name") + "\n" + "os.arch : " + System.getProperty("os.arch") + "\n" + "java.version : " + System.getProperty("java.version") + "\n";
    }
}

