/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import groovy.lang.GroovyClassLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import ss.MainWindow;
import ss.PropertiesWorker;
import ss.ScriptContainer;
import ss.TextSource;
import ss.WebCommunicator;
import ss.desktop.ArgumentParser;
import ss.desktop.EditorFrame;
import ss.desktop.Gauge;
import ss.desktop.Main;
import ss.desktop.PrettyButton;
import ss.desktop.Script;

public class MainFrame
extends JFrame
implements TextSource,
MainWindow {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_HEIGHT = 700;
    private static final int DEFAULT_WIDTH = 900;
    private static final int NB_MAX_BUTTONS = 5;
    private static final int DELAY_SHOW_WAIT_ICON_S = 60;
    private static final int SHOWBUTTON_WAIT_SECURITY_MARGIN_MS = 10;
    private boolean discreetMode;
    private boolean stealthMode;
    private ScriptContainer sc;
    private PropertiesWorker propertiesWorker;
    private ImageIcon imageIcon = null;
    private String text = "";
    private JLabel label;
    private Gauge gauge;
    private PrettyButton button;
    private JTextField textField;
    private PrettyButton[] buttons;
    private JComponent lastChoice;
    private JComboBox<String> comboBox;
    private float speed = 1.0f;
    private Thread thread = null;
    private JMenuItem mReset;
    private JMenuItem mAutoCopy;
    private JMenu mSpeed;
    private JFileChooser fc;
    private EditorFrame editor;
    private ImageIcon backgroundImage;
    private JLabel infoLabel;
    private long buttonStartTimestamp;
    private float buttonResultSeconds;
    private String lastTextForClipboard;

    public MainFrame(String[] args) {
        ArgumentParser ap = new ArgumentParser(args);
        this.discreetMode = ap.containsKey("discreet") || ap.containsKey("t");
        boolean bl = this.stealthMode = ap.containsKey("stealth") || ap.containsKey("s") || this.discreetMode;
        this.propertiesWorker = ap.containsKey("data") ? new PropertiesWorker(this, (String)ap.get("data")) : (ap.containsKey("d") ? new PropertiesWorker(this, (String)ap.get("d")) : new PropertiesWorker(this, "data.properties"));
        this.propertiesWorker.updateSystemProperties();
        this.sc = new ScriptContainer();
        this.createMenu();
        this.createFrame();
        this.startIntroScript(args);
    }

    private void startIntroScript(String[] args) {
        String startScript = this.propertiesWorker.loadString("intro.start_script");
        ArgumentParser ap = new ArgumentParser(args);
        if (ap.containsKey("default")) {
            startScript = (String)ap.get("default");
        }
        if (ap.containsKey("script")) {
            startScript = (String)ap.get("script");
        }
        if (startScript == null) {
            startScript = "intro";
        }
        this.launchSpecialScript(startScript);
    }

    @Override
    public void dispose() {
        this.stopScriptThreads();
        if (this.editor != null) {
            this.editor.dispose();
        }
        super.dispose();
    }

    @Override
    public File getDataFolder() {
        return new File(".");
    }

    @Override
    public File getTmpFolder() {
        return new File(".");
    }

    @Override
    public String readScript(String fileName) {
        this.sc.currentScriptFileName = fileName;
        try {
            this.sc.readFromFile();
            if (!this.sc.forgetScriptAtEnd) {
                String name = new File(this.getDataFolder(), this.sc.currentScriptFileName).getName();
                name = name.substring(0, name.lastIndexOf("."));
                this.setTitle(name);
            }
            if (this.editor != null) {
                this.editor.setText(this.sc.currentScriptText);
            }
            this.updateMenu();
            return this.sc.currentScriptText;
        }
        catch (Exception e) {
            this.showMessage("Could not read : " + e, true);
            this.sc.currentScriptFileName = null;
            this.sc.currentScriptText = "";
            this.updateMenu();
            return "";
        }
    }

    @Override
    public void writeScript(String fileName, boolean alsoUpdateInterface) {
        if (!fileName.toLowerCase().endsWith(".groovy")) {
            fileName = String.valueOf(fileName) + ".groovy";
        }
        try {
            OutputStreamWriter f = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), Charset.forName("UTF-8"));
            f.write(this.sc.currentScriptText);
            ((Writer)f).close();
            if (alsoUpdateInterface) {
                this.sc.currentScriptFileName = fileName;
                String name = new File(this.sc.currentScriptFileName).getName();
                name = name.substring(0, name.lastIndexOf("."));
                this.setTitle(name);
                this.updateMenu();
            }
        }
        catch (Exception e) {
            this.showMessage("Could not write : " + e, true);
        }
    }

    @Override
    public File getFileFromChooser(boolean groovyFilter, File baseFolder, String dialogTitle, Object parent) {
        if (this.fc == null) {
            try {
                this.fc = new JFileChooser();
            }
            catch (Exception ex) {
                Main.setLookAndFeel(false);
                this.fc = new JFileChooser();
            }
        }
        if (baseFolder != null) {
            this.fc.setCurrentDirectory(new File("scripts/"));
        }
        if (dialogTitle != null) {
            this.fc.setDialogTitle(dialogTitle);
        }
        if (groovyFilter) {
            this.fc.addChoosableFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return MainFrame.this.getString("groovy_ext_descr", new Object[0]);
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".groovy");
                }
            });
        }
        int res = parent != null ? this.fc.showOpenDialog((Component)parent) : this.fc.showOpenDialog(this);
        Main.setLookAndFeel(true);
        if (res == 0) {
            this.sc.forgetScriptAtEnd = false;
            return this.fc.getSelectedFile();
        }
        return null;
    }

    protected void showOnlineHelp() {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI("https://ss.deviatenow.com/viewtopic.php?f=3&t=175"));
        }
        catch (Exception e) {
            this.showMessage(this.getString("error", "https://ss.deviatenow.com/viewtopic.php?f=3&t=175 " + e.toString()), true);
        }
    }

    @Override
    public void showAbout() {
        GraphicsDevice device;
        String lastAuthor = this.sc.savedAuthor;
        if (lastAuthor == null) {
            lastAuthor = "/";
        }
        String localModified = "?";
        String yearsString = "2011-";
        Date datelocalModified = this.getLocalModifiedDate();
        if (datelocalModified != null) {
            DateFormat df = DateFormat.getDateInstance();
            localModified = df.format(datelocalModified);
            yearsString = String.valueOf(yearsString) + new SimpleDateFormat("yyyy").format(datelocalModified);
        }
        String onlineModified = "?";
        WebCommunicator webCommunicator = new WebCommunicator();
        Date dateOnlineModified = webCommunicator.getOnlineModifiedDate(WebCommunicator.OnlineModifiedFileType.ZIP);
        if (dateOnlineModified != null) {
            DateFormat df = DateFormat.getDateInstance();
            onlineModified = df.format(dateOnlineModified);
        }
        if ((device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()).getFullScreenWindow() == this) {
            device.setFullScreenWindow(null);
        }
        JOptionPane.showMessageDialog(null, this.getString("about", yearsString, localModified, onlineModified, this.getString("translator", new Object[0]), lastAuthor), this.getString("title", new Object[0]), 1);
    }

    @Override
    public void changeColor(int colori) {
        Color color = new Color(colori);
        ((JPanel)this.getContentPane()).setBackground(color);
        if (color.getRed() + color.getGreen() + color.getBlue() < 384) {
            this.label.setForeground(Color.WHITE);
        } else {
            this.label.setForeground(Color.BLACK);
        }
        this.button.setColor(color);
        PrettyButton[] prettyButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            PrettyButton pb = prettyButtonArray[n2];
            pb.setColor(color);
            ++n2;
        }
    }

    @Override
    public void setTitle(String title) {
        if (!(title = title.trim()).contains(this.getString("title", new Object[0]))) {
            title = title.equals("") ? this.getString("title", new Object[0]) : String.valueOf(this.getString("title", new Object[0])) + " - " + title;
        }
        super.setTitle(title);
        if (this.editor != null) {
            this.editor.setTitle(title);
        }
    }

    @Override
    public void updateTextAndImage() {
        if (this.imageIcon != null) {
            ImageIcon usedII = this.imageIcon;
            double maxTooBigRatio = Math.max(1.0, (double)this.imageIcon.getIconWidth() / (0.6 * (double)this.getWidth()));
            if ((maxTooBigRatio = Math.max(maxTooBigRatio, (double)this.imageIcon.getIconHeight() / (0.8 * (double)this.getHeight()))) > 1.0 && (usedII = new ImageIcon(this.imageIcon.getImage().getScaledInstance((int)((double)this.imageIcon.getIconWidth() / maxTooBigRatio), (int)((double)this.imageIcon.getIconHeight() / maxTooBigRatio), 4))).getImageLoadStatus() != 8) {
                usedII = new ImageIcon(this.imageIcon.getImage().getScaledInstance((int)((double)this.imageIcon.getIconWidth() / maxTooBigRatio), (int)((double)this.imageIcon.getIconHeight() / maxTooBigRatio), 2));
            }
            if (!this.discreetMode) {
                this.label.setIcon(usedII);
            }
        } else {
            this.label.setIcon(null);
        }
        this.lastTextForClipboard = this.text;
        if (this.text.equals("")) {
            this.label.setText("");
        } else {
            int iconWidth = 0;
            if (this.label.getIcon() != null) {
                iconWidth = this.label.getIcon().getIconWidth();
            }
            int textWidth = this.getWidth() - 20 - this.label.getIconTextGap() - iconWidth;
            int textHeight = this.getHeight() - 60;
            float baseSize = (float)((double)1.2f * Math.sqrt(textHeight * textWidth / (this.text.length() + this.text.split("\n").length * 45)));
            float size = Math.round(10.0f * Math.max(4.0f, Math.min(19.0f, baseSize))) / 10;
            if (this.discreetMode) {
                size /= 2.0f;
            }
            if (size != (float)this.label.getFont().getSize()) {
                this.label.setFont(this.label.getFont().deriveFont(size));
            }
            this.label.setText("<html>" + this.text.trim().replace("\n", "<br />") + "</html>");
            if (this.mAutoCopy.isSelected()) {
                this.copyTextToClipboard();
            }
        }
    }

    @Override
    public void setWaiting(boolean waiting) {
        if (this.editor != null) {
            if (waiting) {
                this.editor.setCursor(new Cursor(3));
            } else {
                this.editor.setCursor(new Cursor(0));
            }
        }
        if (waiting) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    @Override
    public void showMessage(String text, boolean error) {
        GraphicsDevice device;
        int messageType = 1;
        if (error) {
            messageType = 0;
        }
        if ((device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()).getFullScreenWindow() == this) {
            device.setFullScreenWindow(null);
        }
        JOptionPane.showMessageDialog(this, text, this.getString("title", new Object[0]), messageType);
    }

    @Override
    public String getInputString(String string, String defaultString) {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (device.getFullScreenWindow() == this) {
            device.setFullScreenWindow(null);
        }
        return JOptionPane.showInputDialog(this, this.getString("import.url", new Object[0]), defaultString);
    }

    @Override
    public PropertiesWorker getPropertiesWorker() {
        return this.propertiesWorker;
    }

    @Override
    public ScriptContainer getScriptContainer() {
        return this.sc;
    }

    @Override
    public void showFromScript(String s) {
        this.text = s == null ? "" : s;
        this.updateTextAndImage();
    }

    @Override
    public float showPopupFromScript(String s) {
        this.buttonStartTimestamp = System.currentTimeMillis();
        this.showMessage(s, false);
        this.buttonResultSeconds = (float)(System.currentTimeMillis() - this.buttonStartTimestamp) / 1000.0f;
        return this.speed * this.buttonResultSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double showButtonFromScript(String s, double duration) {
        if (s == null) {
            s = "";
        }
        this.buttonStartTimestamp = System.currentTimeMillis();
        this.button.setText("<html>" + s.trim().replace("\n", "<br />") + "</html>");
        this.button.setVisible(true);
        this.button.requestFocusInWindow();
        try {
            PrettyButton prettyButton = this.button;
            synchronized (prettyButton) {
                this.button.wait((long)(duration * 1000.0 / (double)this.speed) + 10L);
                this.button.setVisible(false);
                this.buttonResultSeconds = this.speed * (float)(System.currentTimeMillis() - this.buttonStartTimestamp) / 1000.0f;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Math.min(duration, (double)this.buttonResultSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStringFromScript(String text, String defaultValue) {
        if (text != null) {
            this.showFromScript(text);
        }
        this.textField.setText(defaultValue);
        this.textField.setVisible(true);
        this.buttons[1].setText((String)UIManager.get("OptionPane.okButtonText"));
        this.buttons[1].setVisible(true);
        this.textField.requestFocusInWindow();
        try {
            PrettyButton prettyButton = this.buttons[1];
            synchronized (prettyButton) {
                this.buttons[1].wait();
                this.textField.setVisible(false);
                this.buttons[1].setVisible(false);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.textField.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBooleanFromScript(String text, String yesMessage, String noMessage) {
        if (text != null) {
            this.showFromScript(text);
        }
        this.buttons[0].setText(yesMessage);
        this.buttons[0].setVisible(true);
        this.buttons[1].setText(noMessage);
        this.buttons[1].setVisible(true);
        this.buttons[0].requestFocusInWindow();
        boolean res = false;
        try {
            PrettyButton prettyButton = this.buttons[1];
            synchronized (prettyButton) {
                this.buttons[1].wait();
                res = this.buttons[0] == this.lastChoice;
                this.buttons[0].setVisible(false);
                this.buttons[1].setVisible(false);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public int getSelectedValueFromScript(String text, List<String> values) {
        if (text != null) {
            this.showFromScript(text);
        }
        if (values.size() > 5) {
            return this.getSelectedValueFromScriptByCombo(text, values);
        }
        int totalCars = 0;
        for (String v : values) {
            totalCars += v.length() + 5;
        }
        if ((double)totalCars > (double)this.getWidth() * 0.1) {
            return this.getSelectedValueFromScriptByCombo(text, values);
        }
        return this.getSelectedValueFromScriptByButtons(text, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSelectedValueFromScriptByCombo(String text, List<String> values) {
        this.comboBox.removeAllItems();
        this.comboBox.addItem("<html><i>?</em></html>");
        for (String value : values) {
            this.comboBox.addItem(value);
        }
        this.comboBox.setVisible(true);
        this.comboBox.setMaximumRowCount(10);
        this.comboBox.requestFocusInWindow();
        try {
            JComboBox<String> jComboBox = this.comboBox;
            synchronized (jComboBox) {
                this.comboBox.wait();
                this.comboBox.setVisible(false);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.comboBox.getSelectedIndex() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSelectedValueFromScriptByButtons(String text, List<String> values) {
        int i = 0;
        while (i < values.size()) {
            this.buttons[i].setText(values.get(i));
            this.buttons[i].setVisible(true);
            ++i;
        }
        this.buttons[0].requestFocusInWindow();
        int res = 0;
        try {
            PrettyButton prettyButton = this.buttons[1];
            synchronized (prettyButton) {
                this.buttons[1].wait();
                int i2 = 0;
                while (i2 < this.buttons.length) {
                    if (this.lastChoice == this.buttons[i2]) {
                        res = i2;
                    }
                    this.buttons[i2].setVisible(false);
                    ++i2;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public void waitFromScript(double duration) {
        try {
            int i = 0;
            while (i < 10) {
                Thread.sleep((int)(duration * 100.0 / (double)this.speed));
                if (duration * (double)i / 10.0 > 60.0 && !this.infoLabel.isEnabled()) {
                    this.updateInfoLabel("waiting", true);
                }
                ++i;
            }
            this.updateInfoLabel("waiting", false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitWithGaugeFromScript(double duration) {
        try {
            this.gauge.setVisible(true);
            int msTot = (int)(duration * 1000.0 / (double)this.speed);
            int i = 0;
            while (i < msTot) {
                this.gauge.setPrc(100.0 * (double)i / (double)msTot);
                this.repaint();
                Thread.sleep(40L);
                msTot = (int)(duration * 1000.0 / (double)this.speed);
                i += 40;
            }
            this.gauge.setVisible(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void setImageFromScript(String imagePath) {
        this.imageIcon = imagePath == null ? null : new ImageIcon(imagePath);
        this.updateTextAndImage();
    }

    @Override
    public void setImageFromScript(byte[] bytes) {
        this.imageIcon = bytes == null ? null : new ImageIcon(bytes);
        this.updateTextAndImage();
    }

    private boolean launchSpecialScript(String name) {
        this.sc.forgetScriptAtEnd = true;
        return this.launchScript(name);
    }

    private boolean launchScript(String name) {
        String nameWithoutExt = name;
        if (nameWithoutExt.toLowerCase().endsWith(".groovy")) {
            nameWithoutExt = nameWithoutExt.substring(0, nameWithoutExt.toLowerCase().lastIndexOf(".groovy"));
        }
        String[] wantedFileNames = new String[]{new File(this.getDataFolder(), "scripts/" + nameWithoutExt + "_" + Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry() + ".groovy").getAbsolutePath(), new File(this.getDataFolder(), "scripts/" + nameWithoutExt + "_" + Locale.getDefault().getLanguage() + ".groovy").getAbsolutePath(), new File(this.getDataFolder(), "scripts/" + nameWithoutExt + ".groovy").getAbsolutePath(), new File(String.valueOf(nameWithoutExt) + ".groovy").getAbsolutePath()};
        String currentScript = "";
        String[] stringArray = wantedFileNames;
        int n = wantedFileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String wantedFileName = stringArray[n2];
            if (new File(wantedFileName).exists()) {
                currentScript = this.readScript(wantedFileName);
                break;
            }
            ++n2;
        }
        if (currentScript.equals("")) {
            return false;
        }
        this.run();
        return true;
    }

    @Override
    public void run() {
        this.stopScriptThreads();
        this.thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                MainFrame.this.hideScriptInteractionComponents();
                GroovyClassLoader gcl = new GroovyClassLoader();
                String nextScript = null;
                try {
                    String fullScript = MainFrame.this.sc.getScriptClassText(false);
                    MainFrame.this.updateMenu();
                    if (fullScript == null) {
                        MainFrame.this.showMessage(MainFrame.this.getString("error", "No script"), true);
                        gcl.close();
                        return;
                    }
                    Class c = gcl.parseClass(fullScript);
                    ((MainFrame)MainFrame.this).sc.currentScript = (Script)c.getConstructor(MainWindow.class, TextSource.class).newInstance(MainFrame.this, MainFrame.this);
                    nextScript = ((MainFrame)MainFrame.this).sc.currentScript.run();
                    ((MainFrame)MainFrame.this).sc.currentScript.stopSoundThreads();
                    gcl.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MainFrame.this.showMessage(MainFrame.this.getString("error", e.getMessage()), true);
                }
                boolean ended = nextScript != null ? !MainFrame.this.launchScript(nextScript) : true;
                if (ended) {
                    MainFrame.this.changeColor(0xFFEEEE);
                    if (((MainFrame)MainFrame.this).sc.forgetScriptAtEnd) {
                        ((MainFrame)MainFrame.this).sc.currentScriptFileName = null;
                        ((MainFrame)MainFrame.this).sc.currentScriptText = "";
                        ((MainFrame)MainFrame.this).sc.savedAuthor = null;
                        ((MainFrame)MainFrame.this).sc.forgetScriptAtEnd = false;
                    }
                    MainFrame.this.setTitle("");
                }
                MainFrame.this.updateMenu();
            }
        };
        this.thread.start();
    }

    @Override
    public void stopScriptThreads() {
        if (this.sc.currentScript != null) {
            this.sc.currentScript.stopSoundThreads();
        }
        try {
            Thread.sleep(46L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.thread != null && this.thread.isAlive() && this.thread != Thread.currentThread()) {
            this.thread.stop();
        }
    }

    @Override
    public String getString(String s, Object ... args) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("texts");
            if (this.stealthMode && bundle.containsKey("stealth." + s)) {
                return String.format(bundle.getString("stealth." + s), args);
            }
            return String.format(bundle.getString(s), args);
        }
        catch (Exception e) {
            return String.format(s, args);
        }
    }

    public void hideScriptInteractionComponents() {
        this.gauge.setVisible(false);
        this.infoLabel.setEnabled(false);
        this.button.setVisible(false);
        PrettyButton[] prettyButtonArray = this.buttons;
        int n = this.buttons.length;
        int n2 = 0;
        while (n2 < n) {
            PrettyButton bt = prettyButtonArray[n2];
            bt.setVisible(false);
            ++n2;
        }
        this.textField.setVisible(false);
        this.comboBox.setVisible(false);
    }

    private void createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu mFile = new JMenu(this.getString("menu.file", new Object[0]));
        mFile.setMnemonic('F');
        jMenuBar.add(mFile);
        JMenuItem mOpen = new JMenuItem(this.getString("menu.open", new Object[0]), new ImageIcon(this.getClass().getResource("images/open.png")));
        mOpen.setMnemonic('O');
        mOpen.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File dstFile;
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                if (device.getFullScreenWindow() == MainFrame.this) {
                    device.setFullScreenWindow(null);
                }
                if ((dstFile = MainFrame.this.getFileFromChooser(true, new File("scripts/"), null, null)) != null) {
                    ((MainFrame)MainFrame.this).sc.forgetScriptAtEnd = false;
                    MainFrame.this.readScript(dstFile.getAbsolutePath());
                    MainFrame.this.run();
                }
            }
        });
        mFile.add(mOpen);
        JMenuItem mImport = new JMenuItem(this.getString("menu.import", new Object[0]), new ImageIcon(this.getClass().getResource("images/import.png")));
        mImport.setMnemonic('I');
        mImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.sc.askForAndImportScript(MainFrame.this, MainFrame.this.getClipboardUrl());
            }
        });
        mFile.add(mImport);
        mFile.add(new JSeparator());
        JMenuItem mExit = new JMenuItem(this.getString("menu.exit", new Object[0]), new ImageIcon(this.getClass().getResource("images/exit.png")));
        mExit.setMnemonic('E');
        mExit.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        mExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.dispose();
            }
        });
        mFile.add(mExit);
        JMenu mScript = new JMenu(this.getString("menu.script", new Object[0]));
        mScript.setMnemonic('S');
        jMenuBar.add(mScript);
        this.mReset = new JMenuItem(this.getString("menu.reset", new Object[0]), new ImageIcon(this.getClass().getResource("images/reset.png")));
        this.mReset.setMnemonic('R');
        this.mReset.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.mReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((MainFrame)MainFrame.this).sc.currentScriptFileName == null) {
                    MainFrame.this.startIntroScript(null);
                } else {
                    MainFrame.this.run();
                }
            }
        });
        mScript.add(this.mReset);
        JMenuItem mEdit = new JMenuItem(this.getString("menu.edit", new Object[0]), new ImageIcon(this.getClass().getResource("images/edit.png")));
        mEdit.setMnemonic('E');
        mEdit.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        mEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.launchEditor();
                MainFrame.this.editor.setVisible(true);
            }
        });
        mScript.add(mEdit);
        JMenu mOptions = new JMenu(this.getString("menu.options", new Object[0]));
        mOptions.setMnemonic('O');
        jMenuBar.add(mOptions);
        JMenuItem mToys = new JMenuItem(this.getString("menu.toys", new Object[0]), new ImageIcon(this.getClass().getResource("images/options.png")));
        mToys.setMnemonic('T');
        mToys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.thread != null && MainFrame.this.thread.isAlive()) {
                    GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                    if (device.getFullScreenWindow() == MainFrame.this) {
                        device.setFullScreenWindow(null);
                    }
                    if (JOptionPane.showConfirmDialog(MainFrame.this, MainFrame.this.getString("warning.interrupt", new Object[0]), MainFrame.this.getString("title", new Object[0]), 2) == 2) {
                        return;
                    }
                }
                MainFrame.this.launchSpecialScript("toys");
            }
        });
        mOptions.add(mToys);
        JMenuItem mWClothes = new JMenuItem(this.getString("menu.womensclothes", new Object[0]), new ImageIcon(this.getClass().getResource("images/options.png")));
        mWClothes.setMnemonic('W');
        mWClothes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.thread != null && MainFrame.this.thread.isAlive()) {
                    GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                    if (device.getFullScreenWindow() == MainFrame.this) {
                        device.setFullScreenWindow(null);
                    }
                    if (JOptionPane.showConfirmDialog(MainFrame.this, MainFrame.this.getString("warning.interrupt", new Object[0]), MainFrame.this.getString("title", new Object[0]), 2) == 2) {
                        return;
                    }
                }
                MainFrame.this.launchSpecialScript("womensclothes");
            }
        });
        mOptions.add(mWClothes);
        JMenuItem mMClothes = new JMenuItem(this.getString("menu.mensclothes", new Object[0]), new ImageIcon(this.getClass().getResource("images/options.png")));
        mMClothes.setMnemonic('M');
        mMClothes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.thread != null && MainFrame.this.thread.isAlive()) {
                    GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                    if (device.getFullScreenWindow() == MainFrame.this) {
                        device.setFullScreenWindow(null);
                    }
                    if (JOptionPane.showConfirmDialog(MainFrame.this, MainFrame.this.getString("warning.interrupt", new Object[0]), MainFrame.this.getString("title", new Object[0]), 2) == 2) {
                        return;
                    }
                }
                MainFrame.this.launchSpecialScript("mensclothes");
            }
        });
        mOptions.add(mMClothes);
        mOptions.add(new JSeparator());
        this.mSpeed = new JMenu(this.getString("menu.speed", new Object[0]));
        this.mSpeed.setIcon(new ImageIcon(this.getClass().getResource("images/normal.png")));
        this.mSpeed.setMnemonic('S');
        mOptions.add(this.mSpeed);
        JCheckBoxMenuItem mS1 = new JCheckBoxMenuItem(this.getString("menu.speed.slow", new Object[0]), new ImageIcon(this.getClass().getResource("images/slow.png")));
        mS1.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        mS1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.changeSpeed(0.5f);
            }
        });
        this.mSpeed.add(mS1);
        JCheckBoxMenuItem mS2 = new JCheckBoxMenuItem(this.getString("menu.speed.normal", new Object[0]), new ImageIcon(this.getClass().getResource("images/normal.png")));
        mS2.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        mS2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.changeSpeed(1.0f);
            }
        });
        this.mSpeed.add(mS2);
        JCheckBoxMenuItem mS3 = new JCheckBoxMenuItem(this.getString("menu.speed.fast", new Object[0]), new ImageIcon(this.getClass().getResource("images/fast.png")));
        mS3.setAccelerator(KeyStroke.getKeyStroke(51, 2));
        mS3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.changeSpeed(2.0f);
            }
        });
        this.mSpeed.add(mS3);
        JCheckBoxMenuItem mS4 = new JCheckBoxMenuItem(this.getString("menu.speed.faster", new Object[0]), new ImageIcon(this.getClass().getResource("images/faster.png")));
        mS4.setAccelerator(KeyStroke.getKeyStroke(52, 2));
        mS4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.changeSpeed(4.0f);
            }
        });
        this.mSpeed.add(mS4);
        this.changeSpeed(1.0f);
        this.mAutoCopy = new JCheckBoxMenuItem(this.getString("menu.autocopy", new Object[0]), new ImageIcon(this.getClass().getResource("images/copy.png")));
        this.mAutoCopy.setMnemonic('C');
        mOptions.add(this.mAutoCopy);
        JMenu mHelp = new JMenu(this.getString("menu.help", new Object[0]));
        mHelp.setMnemonic('H');
        jMenuBar.add(mHelp);
        JMenuItem mOnlineHelp = new JMenuItem(this.getString("menu.onlinehelp", new Object[0]), new ImageIcon(this.getClass().getResource("images/onlinehelp.png")));
        mOnlineHelp.setMnemonic('O');
        mOnlineHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showOnlineHelp();
            }
        });
        mHelp.add(mOnlineHelp);
        mHelp.add(new JSeparator());
        JMenuItem mAbout = new JMenuItem(this.getString("menu.about", new Object[0]), new ImageIcon(this.getClass().getResource("images/about.png")));
        mAbout.setMnemonic('A');
        mAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.this.showAbout();
            }
        });
        mHelp.add(mAbout);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(new KeyEventPostProcessor(){

            @Override
            public boolean postProcessKeyEvent(KeyEvent e) {
                if (e.getID() == 401 && MainFrame.this.isActive()) {
                    if (e.getKeyCode() == 67 && e.isControlDown() && MainFrame.this.isActive()) {
                        MainFrame.this.copyTextToClipboard();
                        return true;
                    }
                    if ((e.getKeyCode() == 37 || e.getKeyCode() == 39) && MainFrame.this.buttons[0].isVisible() && MainFrame.this.buttons[1].isVisible()) {
                        int n = 0;
                        PrettyButton[] prettyButtonArray = MainFrame.this.buttons;
                        int n2 = prettyButtonArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            PrettyButton bt = prettyButtonArray[n3];
                            if (bt.isVisible()) {
                                ++n;
                            }
                            ++n3;
                        }
                        int newFocus = 0;
                        int i = 0;
                        while (i < n) {
                            if (MainFrame.this.buttons[i].isFocusOwner()) {
                                if (e.getKeyCode() == 37) {
                                    newFocus = (i + n - 1) % n;
                                    break;
                                }
                                newFocus = (i + 1) % n;
                                break;
                            }
                            ++i;
                        }
                        MainFrame.this.buttons[newFocus].requestFocus();
                    }
                    if (e.isAltDown() && e.getKeyCode() == 10) {
                        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                        if (device.getFullScreenWindow() == MainFrame.this) {
                            device.setFullScreenWindow(null);
                        } else {
                            device.setFullScreenWindow(MainFrame.this);
                        }
                    }
                }
                return false;
            }
        });
    }

    private void createFrame() {
        this.setDefaultCloseOperation(3);
        this.setTitle("");
        String backgroundImageFilename = this.propertiesWorker.loadString("application.background");
        if (backgroundImageFilename == null) {
            backgroundImageFilename = "images/background.png";
        }
        this.backgroundImage = new ImageIcon(backgroundImageFilename);
        try {
            BufferedImage icon = this.stealthMode ? ImageIO.read(this.getClass().getResource("images/logo_stealth.png")) : ImageIO.read(this.getClass().getResource("images/logo.png"));
            this.setIconImage(icon);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JPanel panel = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics g) {
                if (this.isOpaque()) {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                MainFrame.this.paintPanelComponent(g);
            }
        };
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(panel);
        GridBagConstraints c = new GridBagConstraints();
        this.label = new JLabel();
        this.label.setHorizontalAlignment(2);
        this.label.setText("");
        String fontProp = this.propertiesWorker.loadString("application.font");
        Font font = fontProp != null ? new Font(fontProp, 0, 19) : this.label.getFont().deriveFont(0, 19.0f);
        this.label.setFont(font);
        this.label.setIconTextGap(20);
        this.label.setDoubleBuffered(true);
        c.gridwidth = 7;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 21;
        c.fill = 2;
        panel.add((Component)this.label, c);
        this.gauge = new Gauge(new BorderLayout());
        this.gauge.setBackground(Color.WHITE);
        this.gauge.setColor(Color.PINK);
        this.gauge.setPreferredSize(new Dimension(250, 40));
        this.gauge.setMinimumSize(new Dimension(100, 40));
        this.gauge.setVisible(false);
        c.gridwidth = 1;
        c.gridy = 1;
        c.anchor = 10;
        c.weightx = 0.4;
        c.weighty = 0.2;
        panel.add((Component)this.gauge, c);
        this.infoLabel = new JLabel();
        this.infoLabel.setText("");
        this.infoLabel.setEnabled(false);
        this.infoLabel.setIgnoreRepaint(true);
        try {
            BufferedImage i = ImageIO.read(this.getClass().getResource("images/infooff.png"));
            this.infoLabel.setDisabledIcon(new ImageIcon(i));
        }
        catch (IOException i) {
            // empty catch block
        }
        c.weightx = 0.2;
        panel.add((Component)this.infoLabel, c);
        JPanel uselessPanel = new JPanel();
        uselessPanel.setOpaque(false);
        uselessPanel.setPreferredSize(new Dimension(10, 55));
        uselessPanel.setMinimumSize(new Dimension(0, 55));
        c.gridx = 1;
        panel.add((Component)uselessPanel, c);
        this.textField = new JTextField();
        this.textField.setFont(font);
        this.textField.setVisible(false);
        this.textField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    MainFrame.this.buttons[1].doClick();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.textField.setPreferredSize(new Dimension(400, this.textField.getPreferredSize().height));
        c.gridwidth = 1;
        c.gridx = 2;
        c.weightx = 1.0;
        panel.add((Component)this.textField, c);
        this.comboBox = new JComboBox();
        this.comboBox.setFont(font);
        this.comboBox.setVisible(false);
        this.comboBox.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jComboBox = MainFrame.this.comboBox;
                synchronized (jComboBox) {
                    if (MainFrame.this.comboBox.isPopupVisible() && MainFrame.this.comboBox.getSelectedIndex() > 0) {
                        MainFrame.this.comboBox.notify();
                    }
                }
            }
        });
        c.gridwidth = 5;
        c.gridx = 2;
        panel.add(this.comboBox, c);
        this.button = new PrettyButton("...", Color.YELLOW);
        this.button.setFont(font);
        this.button.setVisible(false);
        this.button.setRolloverEnabled(true);
        this.button.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                PrettyButton prettyButton = MainFrame.this.button;
                synchronized (prettyButton) {
                    MainFrame.this.button.notify();
                }
            }
        });
        c.gridwidth = 5;
        c.gridx = 2;
        panel.add((Component)this.button, c);
        this.buttons = new PrettyButton[5];
        int n = 0;
        while (n < 5) {
            this.buttons[n] = new PrettyButton("...", Color.BLUE);
            this.buttons[n].setFont(font);
            this.buttons[n].setVisible(false);
            this.buttons[n].setRolloverEnabled(true);
            this.buttons[n].addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    PrettyButton prettyButton = MainFrame.this.buttons[1];
                    synchronized (prettyButton) {
                        MainFrame.this.lastChoice = (JButton)e.getSource();
                        MainFrame.this.buttons[1].notify();
                    }
                }
            });
            c.gridwidth = 1;
            c.gridx = 2 + n;
            c.weightx = 0.12;
            c.fill = 0;
            panel.add((Component)this.buttons[n], c);
            ++n;
        }
        this.pack();
        Integer width = this.propertiesWorker.loadInteger("application.width");
        Integer height = this.propertiesWorker.loadInteger("application.height");
        Integer left = this.propertiesWorker.loadInteger("application.left");
        Integer top = this.propertiesWorker.loadInteger("application.top");
        if (width == null) {
            width = 900;
        }
        if (height == null) {
            height = 700;
        }
        if (left == null || top == null) {
            this.setSize(width, height);
            this.setLocationRelativeTo(null);
        } else {
            this.setBounds(left, top, width, height);
        }
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                MainFrame.this.saveSizeAndPosition();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MainFrame.this.saveSizeAndPosition();
                MainFrame.this.updateTextAndImage();
            }
        });
        this.changeColor(0xFFEEEE);
        this.setVisible(true);
    }

    private void saveSizeAndPosition() {
        if (this.getState() == 0) {
            this.propertiesWorker.save("application.width", this.getWidth());
            this.propertiesWorker.save("application.height", this.getHeight());
            this.propertiesWorker.save("application.left", this.getX());
            this.propertiesWorker.save("application.top", this.getY());
        }
    }

    private void paintPanelComponent(Graphics g) {
        g.drawImage(this.backgroundImage.getImage(), 0, 0, this.getWidth(), this.backgroundImage.getIconHeight() * this.getWidth() / this.backgroundImage.getIconWidth(), 0, 0, this.backgroundImage.getIconWidth(), this.backgroundImage.getIconHeight(), null);
    }

    private void changeSpeed(float speed) {
        this.speed = speed;
        this.updateMenu();
    }

    public void updateMenu() {
        ((JMenuItem)this.mSpeed.getMenuComponent(0)).setSelected(this.speed == 0.5f);
        ((JMenuItem)this.mSpeed.getMenuComponent(1)).setSelected(this.speed == 1.0f);
        ((JMenuItem)this.mSpeed.getMenuComponent(2)).setSelected(this.speed == 2.0f);
        ((JMenuItem)this.mSpeed.getMenuComponent(3)).setSelected(this.speed == 4.0f);
        if (this.mReset != null && this.sc != null) {
            this.mReset.setEnabled(this.sc.currentScriptFileName != null || this.sc.currentScriptText == null || this.sc.currentScriptText.equals(""));
            if (this.editor != null && this.editor.isUnsaved()) {
                this.mReset.setText(String.valueOf(this.getString("menu.reset", new Object[0])) + " * ");
            } else {
                this.mReset.setText(this.getString("menu.reset", new Object[0]));
            }
        }
    }

    private void launchEditor() {
        if (this.editor == null || !this.editor.isDisplayable()) {
            this.editor = new EditorFrame(this);
        }
        this.editor.setTitle(this.getTitle());
    }

    private Date getLocalModifiedDate() {
        Date res = null;
        try {
            File f = new File(this.getClass().getClassLoader().getResource("ss/Main.class").toURI());
            if (f != null && f.exists()) {
                res = new Date(f.lastModified());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (res == null) {
                res = new Date(new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).lastModified());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    @Override
    public void setPlayingSound(boolean playingSound) {
        this.updateInfoLabel("speaker", playingSound);
    }

    private void updateInfoLabel(String image, boolean enabled) {
        if (enabled && !image.equals(this.infoLabel.getName())) {
            try {
                BufferedImage i = ImageIO.read(this.getClass().getResource("images/" + image + ".png"));
                this.infoLabel.setIcon(new ImageIcon(i));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.infoLabel.setName(image);
        }
        if (enabled) {
            this.infoLabel.setEnabled(true);
        }
        if (!enabled && image.equals(this.infoLabel.getName())) {
            this.infoLabel.setEnabled(false);
        }
    }

    private void copyTextToClipboard() {
        try {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            StringSelection data = new StringSelection(this.lastTextForClipboard);
            clipboard.setContents(data, data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getClipboardUrl() {
        String res = "";
        try {
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            String content = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
            String[] strings = content.split("\n");
            if (strings[0].contains("://")) {
                res = strings[0];
            }
        }
        catch (IOException iOException) {
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }
}

