/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import groovy.json.JsonSlurper;
import java.awt.Cursor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import ss.TextSource;
import ss.desktop.EditorFrame;
import ss.desktop.Importator;

public class MilovanaImportator
extends Importator {
    private static final int MILOVANA_DELAY_LETTERS_1S = 18;
    private static final int MILOVANA_BASE_DELAY = 2;
    private static final int STAR_RANDOM_NB_RESOURCES = 6;
    private static final boolean NOCACHE = false;
    private EditorFrame editor;

    @Override
    public String doImport(TextSource textSource, EditorFrame editor) {
        String url;
        block5: {
            this.editor = editor;
            try {
                String clipboardUrl = editor.getClipboardUrl();
                url = JOptionPane.showInputDialog(textSource.getString("milovana.url", new Object[0]), (Object)clipboardUrl);
                if (url != null) break block5;
                return null;
            }
            catch (Exception e) {
                editor.addInfo(textSource.getString("error", e.toString()));
                editor.setCursor(new Cursor(0));
                e.printStackTrace();
                return null;
            }
        }
        if (!url.contains("://")) {
            url = "http://" + url;
        }
        if (url.contains("showflash")) {
            return this.doImportFlash(textSource, editor, url);
        }
        return this.doImportTease(textSource, editor, url);
    }

    private String doImportTease(TextSource textSource, EditorFrame editor, String url) throws IOException {
        String res = "";
        String baseUrl = url;
        baseUrl = baseUrl.substring(0, 9 + baseUrl.substring(8).indexOf("/"));
        int withDelay = JOptionPane.showConfirmDialog(editor, textSource.getString("milovana.delay", new Object[0]));
        if (withDelay == 2) {
            return null;
        }
        boolean writeDelays = withDelay == 0;
        res = String.valueOf(res) + "\n\n// Milovana - " + url + "\n// " + textSource.getString("milovana.rights", new Object[0]);
        JOptionPane.showMessageDialog(editor, textSource.getString("milovana.please_wait", new Object[0]));
        editor.setCursor(new Cursor(3));
        int id = 0;
        String imageFolder = "milovana/";
        String mp3Folder = "milovana/";
        if (url.contains("id=")) {
            String idStr = url.substring(url.indexOf("id=") + 3);
            if (idStr.contains("&")) {
                idStr = idStr.substring(0, idStr.indexOf("&"));
            }
            id = Integer.parseInt(idStr);
            imageFolder = String.valueOf(imageFolder) + id + "/";
            mp3Folder = String.valueOf(mp3Folder) + id + "/";
        }
        int n = 0;
        HashSet<String> images = new HashSet<String>();
        HashSet<String> mp3s = new HashSet<String>();
        do {
            editor.addInfo(url);
            String html = editor.getUrlContent(url);
            if (html.contains("FlashTease #")) {
                return this.doImportFlash(textSource, editor, url);
            }
            if (html.contains("https://eosscript.com?host")) {
                return this.doImportEos(textSource, editor, url, id, html, writeDelays);
            }
            String image = null;
            String mp3 = null;
            String text = null;
            Pattern pattern = Pattern.compile("src=\"(https?://[^\"]*)\"[^>]*class\\s?=\\s?\"tease_pic\"");
            Matcher matcher = pattern.matcher(html);
            if (matcher.find()) {
                try {
                    String imageUrl = matcher.group(1);
                    image = this.getDownloadedFile("images/" + imageFolder, n, images, imageUrl, editor);
                }
                catch (IOException imageUrl) {
                    // empty catch block
                }
            }
            if ((matcher = (pattern = Pattern.compile("<a href=\"(https?://media.milovana.com/timg[^\"]*\\.mp3)\"")).matcher(html)).find()) {
                try {
                    String mp3Url = matcher.group(1);
                    mp3 = this.getDownloadedFile("sounds/" + mp3Folder, n, mp3s, mp3Url, editor);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((matcher = (pattern = Pattern.compile("<p\\s+class=\"text\"\\s*>(([^<]*<br\\s*/>)*[^<]*)</p>")).matcher(html)).find()) {
                text = matcher.group(1).trim().replace("\n", "");
                text = text.replace("<br />", "\n").replace("\"", "\\\"").replace("$", "\\$");
                if ((text = text.replace("\n", "\\n\"+\n\t\"")) != null) {
                    if (image != null) {
                        res = String.valueOf(res) + "\nsetImage(\"" + imageFolder + image + "\")";
                    }
                    res = String.valueOf(res) + "\nshow(\"" + text + "\")" + "\n";
                    if (mp3 != null) {
                        res = String.valueOf(res) + "\nplaySound(\"" + mp3Folder + mp3 + "\")";
                    }
                    if (writeDelays && mp3 == null) {
                        res = String.valueOf(res) + "wait(" + (2 + text.length() / 18) + ")";
                    }
                    if (!writeDelays) {
                        res = String.valueOf(res) + "showButton(\"Continue\")";
                    }
                    res = String.valueOf(res) + "\n";
                }
            }
            if ((matcher = (pattern = Pattern.compile("<p\\s+class=\"link\"\\s*>\\s*<a\\s+href=\"([^\"]*)\"")).matcher(html)).find()) {
                url = matcher.group(1);
                if (url.contains("//")) continue;
                url = String.valueOf(baseUrl) + url;
                continue;
            }
            url = null;
        } while (url != null && ++n < 1000);
        if (n == 1000) {
            editor.addInfo(textSource.getString("error", "1000 URL ?"));
        }
        res = String.valueOf(res) + "\nshow(\"Goodbye\")";
        editor.setCursor(new Cursor(0));
        editor.addInfo("OK");
        return res;
    }

    private String doImportFlash(TextSource textSource, EditorFrame editor, String url) throws IOException {
        Pattern pattern = Pattern.compile("(\\d{2,7})");
        Matcher matcher = pattern.matcher(url);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Incomplete URL");
        }
        JOptionPane.showMessageDialog(editor, textSource.getString("milovana.please_wait", new Object[0]));
        editor.setCursor(new Cursor(3));
        String id = matcher.group(1);
        String baseHtml = editor.getUrlContent(url);
        pattern = Pattern.compile("author=(\\d{1,7})");
        matcher = pattern.matcher(baseHtml);
        if (!matcher.find()) {
            throw new IllegalArgumentException("No author ?");
        }
        String authorId = matcher.group(1);
        String baseResourceString = "http://www.milovana.com/media/get.php?folder=" + authorId + "/" + id + "&name=";
        String scriptUrl = "http://www.milovana.com/webteases/getscript.php?id=" + id;
        editor.addInfo(textSource.getString("Content URL : " + scriptUrl, new Object[0]));
        String[] lines = editor.getUrlContent(scriptUrl).split("\n");
        ArrayList<String> pageCodes = new ArrayList<String>();
        String realLine = "";
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((realLine = String.valueOf(realLine) + line.trim()).endsWith(")")) {
                pageCodes.add(realLine);
                realLine = "";
            }
            ++n2;
        }
        if (pageCodes.size() < 2) {
            throw new IllegalArgumentException("Only " + pageCodes.size() + " pages, aborting");
        }
        boolean probablyBig = pageCodes.size() > 20;
        String startBlock = "";
        String content = "";
        Pattern patternFullPage = Pattern.compile("(\\w+#)\\{?page\\((.*)\\)");
        Pattern patternPageText = Pattern.compile("text:'(([^']+|\\\\')*[^\\\\])'");
        Pattern patternFirstColor = Pattern.compile("COLOR=\"#([^\"]+)\"");
        Pattern patternPagePic = Pattern.compile("media:pic\\(id:(\"|')([^\"']*)(\"|')");
        Pattern patternSound = Pattern.compile("(hidden|action|e0|e1|e2|e3|instruc):sound\\(id:(\"|')([^\"']*)(\"|')");
        Pattern patternPageActionGo = Pattern.compile("(action|e0|e1|e2|e3|instruc):go\\(target:([^\\)]*)\\)");
        Pattern patternPageActionYn = Pattern.compile("(action|e0|e1|e2|e3|instruc):yn\\(yes:([^,]*),no:([^\\)]*)\\)");
        Pattern patternPageActionButtons = Pattern.compile("(action|e0|e1|e2|e3|instruc):buttons\\((target\\d+:\\w+#,cap\\d+:\"[^\"]*\"(,target\\d+:\\w+#,cap\\d+:\"[^\"]*\")*)\\)");
        Pattern patternDelay = Pattern.compile("(action|e0|e1|e2|e3|instruc):delay\\(time:(((\\d+)(\\w+))|(random\\(min:(\\d+)(\\w+),max:(\\d+)(\\w+)\\))),target:(([^#]+#)|(range\\(from:(\\d+),to:(\\d+)[^\\)]*\\)))(,style:([^\\)]*))?\\)");
        String imageFolder = "milovana/";
        String mp3Folder = "milovana/";
        imageFolder = String.valueOf(imageFolder) + id + "/";
        mp3Folder = String.valueOf(mp3Folder) + id + "/";
        HashSet<String> images = new HashSet<String>();
        HashSet<String> mp3s = new HashSet<String>();
        String firstColor = null;
        int n3 = 1;
        for (String pageCode : pageCodes) {
            if (pageCode.endsWith("text:'',media:pic(id:\"*.jpg\"))")) continue;
            matcher = patternFullPage.matcher(pageCode);
            if (matcher.find()) {
                String pageName = matcher.group(1);
                String pageContent = matcher.group(2);
                if (startBlock.equals("")) {
                    startBlock = pageName;
                }
                content = probablyBig ? String.valueOf(content) + "case \"" + pageName + "\":{->" : String.valueOf(content) + "case \"" + pageName + "\":";
                String image = null;
                String mp3 = null;
                String text = null;
                Matcher m2 = patternPageText.matcher(pageContent);
                text = m2.find() ? m2.group(1) : "";
                Matcher mFirstColor = patternFirstColor.matcher(text);
                if (mFirstColor.find()) {
                    firstColor = mFirstColor.group(1);
                }
                if ((m2 = patternPagePic.matcher(pageContent)).find()) {
                    try {
                        String imageUrl = String.valueOf(baseResourceString) + m2.group(2);
                        image = this.getDownloadedFile("images/" + imageFolder, n3, images, imageUrl, editor);
                    }
                    catch (IOException imageUrl) {
                        // empty catch block
                    }
                }
                if ((m2 = patternSound.matcher(pageContent)).find()) {
                    try {
                        String mp3Url = String.valueOf(baseResourceString) + m2.group(3);
                        mp3 = this.getDownloadedFile("sounds/" + mp3Folder, n3, mp3s, mp3Url, editor);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                text = text.replace("$", "\\$");
                text = text.replace("\"", "\\\"");
                text = text.replace("&apos;", "'");
                if (image != null) {
                    content = image.contains("*") ? String.valueOf(content) + "\n\tsetImage(\"" + imageFolder + image + "\".replace(\"*\",\"\"+getRandom(" + 6 + "))" + ")" : String.valueOf(content) + "\n\tsetImage(\"" + imageFolder + image + "\")";
                }
                int s = 5;
                while (s < 40) {
                    text = text.replace("SIZE=\\\"" + s + "\\\"", "SIZE=\\\"" + (2 + s / 4) + "\\\"");
                    ++s;
                }
                content = String.valueOf(content) + "\n\tshow(\"" + text + "\")";
                if (mp3 != null) {
                    content = mp3.contains("*") ? String.valueOf(content) + "\n\tplayBackgroundSound(\"" + mp3Folder + mp3 + "\".replace(\"*\",\"\"+getRandom(" + 6 + "))" + ")" : String.valueOf(content) + "\n\tplayBackgroundSound(\"" + mp3Folder + mp3 + "\")";
                }
                boolean goneSomewhere = false;
                boolean delayWasUsed = false;
                boolean hasDelay = false;
                boolean delayIsSecret = false;
                String delayDurationStr = "";
                String blockAfterDelayStr = null;
                m2 = patternDelay.matcher(pageContent);
                if (m2.find()) {
                    int delayDuration = 0;
                    int delayAddRandom = 0;
                    hasDelay = true;
                    if (m2.group(4) != null) {
                        delayDuration = Integer.parseInt(m2.group(4));
                        if (m2.group(5).equals("min")) {
                            delayDuration *= 60;
                        }
                        if (m2.group(5).equals("hrs")) {
                            delayDuration *= 3600;
                        }
                    } else {
                        delayDuration = Integer.parseInt(m2.group(7));
                        if (m2.group(8).equals("min")) {
                            delayDuration *= 60;
                        }
                        if (m2.group(8).equals("hrs")) {
                            delayDuration *= 3600;
                        }
                        delayAddRandom = Integer.parseInt(m2.group(9));
                        if (m2.group(10).equals("min")) {
                            delayAddRandom *= 60;
                        }
                        if (m2.group(10).equals("hrs")) {
                            delayAddRandom *= 3600;
                        }
                        delayAddRandom -= delayDuration;
                    }
                    delayDurationStr = "" + delayDuration;
                    if (delayAddRandom > 0) {
                        delayDurationStr = "(" + delayDuration + "+getRandom(" + delayAddRandom + "))";
                    }
                    blockAfterDelayStr = m2.group(12) != null ? "block=\"" + m2.group(12) + "\"" : "block=(" + m2.group(14) + "+ getRandom(" + (1 + Integer.parseInt(m2.group(15)) - Integer.parseInt(m2.group(14))) + "))+\"#\"";
                    boolean bl = delayIsSecret = m2.group(16) != null;
                }
                if ((m2 = patternPageActionGo.matcher(pageContent)).find()) {
                    content = String.valueOf(content) + "\n\tblock=\"" + m2.group(2) + "\"";
                    if (hasDelay) {
                        content = String.valueOf(content) + "\n\tif(showButton(\"Continue\"," + delayDurationStr + ")>=" + delayDurationStr + ")" + "\n\t\t" + blockAfterDelayStr;
                        delayWasUsed = true;
                    } else {
                        content = String.valueOf(content) + "\n\tshowButton(\"Continue\")";
                    }
                    goneSomewhere = true;
                }
                if ((m2 = patternPageActionYn.matcher(pageContent)).find()) {
                    if (hasDelay) {
                        content = String.valueOf(content) + "\n\tdef startTime" + n3 + " = getTime()";
                    }
                    content = String.valueOf(content) + "\n\tif(getBoolean(null))\n\t\tblock=\"" + m2.group(2) + "\"" + "\n\telse\n\t\tblock=\"" + m2.group(3) + "\"";
                    if (hasDelay) {
                        content = String.valueOf(content) + "\n\tdef endTime" + n3 + " = getTime()" + "\n\tif(endTime" + n3 + " - startTime" + n3 + " > " + delayDurationStr + ")" + "\n\t\t" + blockAfterDelayStr;
                        delayWasUsed = true;
                    }
                    goneSomewhere = true;
                }
                if ((m2 = patternPageActionButtons.matcher(pageContent)).find()) {
                    String[] buttons = m2.group(2).split(",targ");
                    Pattern patternOneButton = Pattern.compile("(targ)?et(\\d)+:([^,]+),cap(\\d+):(('(([^']|\\\\')+)')|(\"(([^\"]|\\\\\")+)\"))");
                    if (buttons.length == 1) {
                        Matcher m3 = patternOneButton.matcher(buttons[0]);
                        m3.find();
                        content = String.valueOf(content) + "\n\tblock=\"" + m3.group(3) + "\"";
                        String btText = m3.group(7);
                        if (btText == null) {
                            btText = m3.group(10);
                        }
                        if (hasDelay) {
                            content = String.valueOf(content) + "\n\tif(showButton(\"" + btText + "\"," + delayDurationStr + ")>=" + delayDurationStr + ")" + "\n\t\t" + blockAfterDelayStr;
                            delayWasUsed = true;
                        } else {
                            content = String.valueOf(content) + "\n\tshowButton(\"" + btText + "\")";
                        }
                    } else {
                        if (hasDelay) {
                            content = String.valueOf(content) + "\n\tdef startTime" + n3 + " = getTime()";
                        }
                        content = String.valueOf(content) + "\n\tdef pages" + n3 + "=[]";
                        content = String.valueOf(content) + "\n\tdef values" + n3 + "=[]";
                        String[] stringArray2 = buttons;
                        int n4 = buttons.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            String button = stringArray2[n5];
                            Matcher m3 = patternOneButton.matcher(button);
                            if (m3.find()) {
                                String btText = m3.group(7);
                                if (btText == null) {
                                    btText = m3.group(10);
                                }
                                content = String.valueOf(content) + "\n\tpages" + n3 + ".add(\"" + m3.group(3) + "\")";
                                content = String.valueOf(content) + "\n\tvalues" + n3 + ".add(\"" + btText + "\")";
                            }
                            ++n5;
                        }
                        content = String.valueOf(content) + "\n\tblock = pages" + n3 + "[getSelectedValue(null, values" + n3 + ")]";
                        if (hasDelay) {
                            content = String.valueOf(content) + "\n\tdef endTime" + n3 + " = getTime()" + "\n\tif(endTime" + n3 + " - startTime" + n3 + " > " + delayDurationStr + ")" + "\n\t\t" + blockAfterDelayStr;
                            delayWasUsed = true;
                        }
                    }
                    goneSomewhere = true;
                }
                if (hasDelay && !delayWasUsed) {
                    content = delayIsSecret ? String.valueOf(content) + "\n\twait(" + delayDurationStr + ")" : String.valueOf(content) + "\n\twaitWithGauge(" + delayDurationStr + ")";
                    content = String.valueOf(content) + "\n\t" + blockAfterDelayStr;
                    goneSomewhere = true;
                }
                if (!goneSomewhere) {
                    content = String.valueOf(content) + "\n\tendReached = true";
                }
                if (mp3 != null && !mp3.equals("")) {
                    content = String.valueOf(content) + "\n\tplayBackgroundSound(null);";
                }
                content = probablyBig ? String.valueOf(content) + "\n\t}(); break\n\n" : String.valueOf(content) + "\n\tbreak\n\n";
            }
            ++n3;
        }
        editor.setCursor(new Cursor(0));
        if (firstColor != null && Integer.parseInt(firstColor, 16) % 256 > 127) {
            editor.addInfo("OK, you should set a dark background in setInfo() ");
        } else {
            editor.addInfo("OK");
        }
        return "\n\n// Milovana - " + url + "\n// " + textSource.getString("milovana.rights", new Object[0]) + "\n" + "def endReached = false\n" + "def block = \"" + startBlock + "\"\n" + "def newBlock = block\n" + "while(!endReached && newBlock!=null) {\n" + "block = null\n" + "switch(newBlock) {\n" + content + "default:\n" + "\tshow(\"Unfinished ? (\"+newBlock+\")\")\n" + "\tendReached = true\n} // end switch \n" + "newBlock = block\n" + "} // end while \n" + "wait(1)\nshowButton(\"Close\")\nshow(\"\")\n";
    }

    private String doImportEos(TextSource textSource, EditorFrame editor, String url, int id, String baseHtml, boolean writeDelays) throws IOException {
        Pattern pattern = Pattern.compile("data-author-id=\"(\\d{1,7})\"");
        Matcher matcher = pattern.matcher(baseHtml);
        if (!matcher.find()) {
            throw new IllegalArgumentException("No author ?");
        }
        String imageFolder = "milovana/";
        String mp3Folder = "milovana/";
        imageFolder = String.valueOf(imageFolder) + id + "/";
        mp3Folder = String.valueOf(mp3Folder) + id + "/";
        HashSet<String> images = new HashSet<String>();
        HashSet<String> mp3s = new HashSet<String>();
        String firstColor = null;
        Pattern patternFirstColor = Pattern.compile("color:\\s?#([A-Fa-f0-9]+)");
        String scriptHtml = editor.getUrlContent("https://milovana.com/webteases/geteosscript.php?id=" + id);
        if (scriptHtml.length() < 100) {
            throw new IllegalArgumentException("No script ?");
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        Map json = (Map)jsonSlurper.parseText(scriptHtml);
        Map pages = (Map)json.get("pages");
        String content = "";
        String startBlock = "";
        int n = 0;
        for (String pageName : pages.keySet()) {
            boolean goneSomewhere = false;
            boolean delayWasUsed = false;
            boolean hasDelay = false;
            boolean delayIsSecret = false;
            String delayDurationStr = null;
            String blockAfterDelayStr = null;
            String image = null;
            String mp3 = null;
            content = String.valueOf(content) + "case \"" + pageName + "\":{->";
            for (Map item : (List)pages.get(pageName)) {
                Map files;
                Matcher mFirstColor;
                Map subItem;
                boolean anyPause = false;
                String text = null;
                if (item.containsKey("say") && (subItem = (Map)item.get("say")).containsKey("label")) {
                    text = (String)subItem.get("label");
                    text = text.replace("$", "\\$");
                    text = text.replace("\"", "\\\"");
                    mFirstColor = patternFirstColor.matcher(text = text.replace("&apos;", "'"));
                    if (mFirstColor.find()) {
                        firstColor = mFirstColor.group(1);
                    }
                    int s = 5;
                    while (s < 40) {
                        text = text.replace("SIZE=\\\"" + s + "\\\"", "SIZE=\\\"" + (2 + s / 4) + "\\\"");
                        ++s;
                    }
                    content = String.valueOf(content) + "\n\tshow(\"" + text + "\")";
                }
                if (item.containsKey("image")) {
                    try {
                        String imageStr = (String)((Map)item.get("image")).get("locator");
                        String imageUrl = null;
                        if (imageStr.startsWith("gallery:")) {
                            String[] parts = imageStr.substring(8).split("/");
                            Map gallery = (Map)((Map)json.get("galleries")).get(parts[0]);
                            if (gallery != null && gallery.containsKey("images")) {
                                for (Map imageJson : (List)gallery.get("images")) {
                                    if (!imageJson.containsKey("id") || !String.valueOf(imageJson.get("id")).equals(parts[1])) continue;
                                    imageUrl = "https://media.milovana.com/timg/tb_xl/" + (String)imageJson.get("hash") + ".jpg?origin=https://eosscript.com";
                                }
                            }
                        } else if (imageStr.startsWith("file:")) {
                            String key = imageStr.substring(5);
                            files = (Map)json.get("files");
                            Map file = (Map)files.get(key);
                            if (file != null) {
                                imageUrl = "https://media.milovana.com/timg/tb_xl/" + (String)file.get("hash") + ".jpg?origin=https://eosscript.com";
                            }
                        }
                        if (imageUrl != null) {
                            image = this.getDownloadedFile("images/" + imageFolder, n, images, imageUrl, editor);
                        }
                        if (image != null) {
                            content = image.contains("*") ? String.valueOf(content) + "\n\tsetImage(\"" + imageFolder + image + "\".replace(\"*\",\"\"+getRandom(" + 6 + "))" + ")" : String.valueOf(content) + "\n\tsetImage(\"" + imageFolder + image + "\")";
                        }
                    }
                    catch (IOException imageStr) {
                        // empty catch block
                    }
                }
                if (item.containsKey("audio.play")) {
                    try {
                        String mp3Str = (String)((Map)item.get("audio.play")).get("locator");
                        String mp3Url = null;
                        if (mp3Str.startsWith("file:")) {
                            String key = mp3Str.substring(5);
                            files = (Map)json.get("files");
                            Map file = (Map)files.get(key);
                            mp3Url = "https://media.milovana.com/timg/" + (String)file.get("hash") + ".mp3";
                        }
                        if ((mp3 = this.getDownloadedFile("sounds/" + mp3Folder, n, mp3s, mp3Url, editor)) != null) {
                            content = mp3.contains("*") ? String.valueOf(content) + "\n\tplayBackgroundSound(\"" + mp3Folder + mp3 + "\".replace(\"*\",\"\"+getRandom(" + 6 + "))" + ")" : String.valueOf(content) + "\n\tplayBackgroundSound(\"" + mp3Folder + mp3 + "\")";
                        }
                    }
                    catch (IOException mp3Str) {
                        // empty catch block
                    }
                }
                if (item.containsKey("goto") && (subItem = (Map)item.get("goto")).containsKey("target")) {
                    String nextPage = (String)subItem.get("target");
                    content = String.valueOf(content) + "\n\tblock=\"" + nextPage + "\"";
                    goneSomewhere = true;
                }
                if (item.containsKey("choice")) {
                    Map subChoiceItem = (Map)item.get("choice");
                    if (subChoiceItem.containsKey("options")) {
                        content = String.valueOf(content) + "\n\tdef values" + n + "=[]";
                        content = String.valueOf(content) + "\n\tdef pages" + n + "=[]";
                        for (Map subSubItem : (List)subChoiceItem.get("options")) {
                            content = String.valueOf(content) + "\n\tvalues" + n + ".add(\"" + (String)subSubItem.get("label") + "\")";
                            content = String.valueOf(content) + "\n\tpages" + n + ".add(\"" + (String)((Map)((Map)((List)subSubItem.get("commands")).get(0)).get("goto")).get("target") + "\")";
                        }
                    }
                    content = String.valueOf(content) + "\n\tblock = pages" + n + "[getSelectedValue(null, values" + n + ")]";
                    goneSomewhere = true;
                    anyPause = true;
                }
                if (item.containsKey("timer")) {
                    hasDelay = true;
                    subItem = (Map)item.get("timer");
                    if (subItem.containsKey("commands")) {
                        Map command = (Map)((List)subItem.get("commands")).get(0);
                        if (command.containsKey("goto")) {
                            blockAfterDelayStr = "block=\"" + (String)((Map)command.get("goto")).get("target") + "\"";
                        }
                        if (command.containsKey("choice")) {
                            Map subChoiceItem = (Map)command.get("choice");
                            if (subChoiceItem.containsKey("options")) {
                                content = String.valueOf(content) + "\n\tdef values" + n + "=[]";
                                content = String.valueOf(content) + "\n\tdef pages" + n + "=[]";
                                for (Map subSubItem : (List)subChoiceItem.get("options")) {
                                    content = String.valueOf(content) + "\n\tvalues" + n + ".add(\"" + (String)subSubItem.get("label") + "\")";
                                    content = String.valueOf(content) + "\n\tpages" + n + ".add(\"" + (String)((Map)((Map)((List)subSubItem.get("commands")).get(0)).get("goto")).get("target") + "\")";
                                }
                            }
                            content = String.valueOf(content) + "\n\tblock = pages" + n + "[getSelectedValue(null, values" + n + ")]";
                            goneSomewhere = true;
                        }
                    }
                    delayIsSecret = subItem.containsKey("style") && ((String)subItem.get("style")).equals("secret");
                    String delaySrc = ((String)subItem.get("duration")).trim();
                    if (!delaySrc.contains("-")) {
                        delayDurationStr = String.valueOf(this.getSecondsFromString(delaySrc));
                    } else {
                        String[] limitsSrc = delaySrc.split("-");
                        float[] limits = new float[2];
                        int i = 0;
                        while (i < 2) {
                            limits[i] = this.getSecondsFromString(limitsSrc[i]);
                            ++i;
                        }
                        delayDurationStr = String.valueOf(limits[0]) + "+getRandom(" + (limits[1] - limits[0]) + ")";
                    }
                    anyPause = true;
                    hasDelay = true;
                }
                if (item.containsKey("nyx.page")) {
                    Map subItem2;
                    Map file;
                    String key;
                    Map nyxItem = (Map)item.get("nyx.page");
                    if (nyxItem.containsKey("text")) {
                        text = (String)nyxItem.get("text");
                        text = text.replace("$", "\\$");
                        text = text.replace("\"", "\\\"");
                        mFirstColor = patternFirstColor.matcher(text = text.replace("&apos;", "'"));
                        if (mFirstColor.find()) {
                            firstColor = mFirstColor.group(1);
                        }
                        int s = 5;
                        while (s < 40) {
                            text = text.replace("SIZE=\\\"" + s + "\\\"", "SIZE=\\\"" + (2 + s / 4) + "\\\"");
                            ++s;
                        }
                        content = String.valueOf(content) + "\n\tshow(\"" + text + "\")";
                    }
                    if (nyxItem.containsKey("media")) {
                        try {
                            String imageStr = (String)((Map)nyxItem.get("media")).get("nyx.image");
                            String imageUrl = null;
                            if (imageStr.startsWith("gallery:")) {
                                String[] parts = imageStr.substring(8).split("/");
                                Map gallery = (Map)((Map)json.get("galleries")).get(parts[0]);
                                for (Map imageJson : (List)gallery.get("images")) {
                                    if (!imageJson.containsKey("id") || !String.valueOf(imageJson.get("id")).equals(parts[1])) continue;
                                    imageUrl = "https://media.milovana.com/timg/tb_xl/" + (String)imageJson.get("hash") + ".jpg?origin=https://eosscript.com";
                                }
                            } else if (imageStr.startsWith("file:")) {
                                key = imageStr.substring(5);
                                Map files2 = (Map)json.get("files");
                                file = (Map)files2.get(key);
                                if (file != null) {
                                    imageUrl = "https://media.milovana.com/timg/tb_xl/" + (String)file.get("hash") + ".jpg?origin=https://eosscript.com";
                                }
                            }
                            if (imageUrl != null) {
                                image = this.getDownloadedFile("images/" + imageFolder, n, images, imageUrl, editor);
                            }
                            if (image != null) {
                                content = image.contains("*") ? String.valueOf(content) + "\n\tsetImage(\"" + imageFolder + image + "\".replace(\"*\",\"\"+getRandom(" + 6 + "))" + ")" : String.valueOf(content) + "\n\tsetImage(\"" + imageFolder + image + "\")";
                            }
                        }
                        catch (IOException imageStr) {
                            // empty catch block
                        }
                    }
                    if (nyxItem.containsKey("hidden")) {
                        try {
                            String mp3Str = (String)((Map)((Map)nyxItem.get("hidden")).get("audio.play")).get("locator");
                            String mp3Url = null;
                            if (mp3Str.startsWith("file:")) {
                                key = mp3Str.substring(5);
                                Map files3 = (Map)json.get("files");
                                file = (Map)files3.get(key);
                                mp3Url = "https://media.milovana.com/timg/" + (String)file.get("hash") + ".mp3";
                            }
                            if ((mp3 = this.getDownloadedFile("sounds/" + mp3Folder, n, mp3s, mp3Url, editor)) != null) {
                                content = mp3.contains("*") ? String.valueOf(content) + "\n\tplayBackgroundSound(\"" + mp3Folder + mp3 + "\".replace(\"*\",\"\"+getRandom(" + 6 + "))" + ")" : String.valueOf(content) + "\n\tplayBackgroundSound(\"" + mp3Folder + mp3 + "\")";
                            }
                        }
                        catch (IOException mp3Str) {
                            // empty catch block
                        }
                    }
                    if (nyxItem.containsKey("goto") && (subItem2 = (Map)nyxItem.get("goto")).containsKey("target")) {
                        String nextPage = (String)subItem2.get("target");
                        content = String.valueOf(content) + "\n\tblock=\"" + nextPage + "\"";
                        goneSomewhere = true;
                    }
                    if (nyxItem.containsKey("action")) {
                        Map action = (Map)nyxItem.get("action");
                        if (action.containsKey("nyx.buttons")) {
                            List subChoiceItems = (List)action.get("nyx.buttons");
                            if (subChoiceItems.size() == 1) {
                                content = String.valueOf(content) + "\n\tshowButton(\"" + ((Map)subChoiceItems.get(0)).get("label") + "\")";
                                content = String.valueOf(content) + "\n\tblock = \"" + (String)((Map)((Map)((List)((Map)subChoiceItems.get(0)).get("commands")).get(0)).get("goto")).get("target") + "\"";
                            } else {
                                content = String.valueOf(content) + "\n\tdef values" + n + "=[]";
                                content = String.valueOf(content) + "\n\tdef pages" + n + "=[]";
                                for (Map subSubItem : subChoiceItems) {
                                    content = String.valueOf(content) + "\n\tvalues" + n + ".add(\"" + (String)subSubItem.get("label") + "\")";
                                    content = String.valueOf(content) + "\n\tpages" + n + ".add(\"" + (String)((Map)((Map)((List)subSubItem.get("commands")).get(0)).get("goto")).get("target") + "\")";
                                }
                                content = String.valueOf(content) + "\n\tblock = pages" + n + "[getSelectedValue(null, values" + n + ")]";
                            }
                            goneSomewhere = true;
                            anyPause = true;
                        }
                        if (action.containsKey("nyx.timer")) {
                            Map command;
                            Map subItem3 = (Map)action.get("nyx.timer");
                            if (subItem3.containsKey("commands") && (command = (Map)((List)subItem3.get("commands")).get(0)).containsKey("goto")) {
                                blockAfterDelayStr = "block=\"" + (String)((Map)command.get("goto")).get("target") + "\"";
                                goneSomewhere = true;
                            }
                            delayIsSecret = subItem3.containsKey("style") && ((String)subItem3.get("style")).equals("secret");
                            String delaySrc = ((String)subItem3.get("duration")).trim();
                            if (!delaySrc.contains("-")) {
                                delayDurationStr = String.valueOf(this.getSecondsFromString(delaySrc));
                            } else {
                                String[] limitsSrc = delaySrc.split("-");
                                Object limits = new float[2];
                                int i = 0;
                                while (i < 2) {
                                    limits[i] = this.getSecondsFromString(limitsSrc[i]);
                                    ++i;
                                }
                                delayDurationStr = String.valueOf((float)limits[0]) + "+getRandom(" + (float)(limits[1] - limits[0]) + ")";
                            }
                            anyPause = true;
                            hasDelay = true;
                        }
                        if (action.containsKey("nyx.vert")) {
                            hasDelay = true;
                            List elements = (List)((Map)action.get("nyx.vert")).get("elements");
                            HashMap elemMap = new HashMap();
                            for (Map e : elements) {
                                String oneKey = (String)e.keySet().iterator().next();
                                elemMap.put(oneKey, e.get(oneKey));
                            }
                            if (elemMap.containsKey("nyx.buttons")) {
                                List subChoiceItems = (List)elemMap.get("nyx.buttons");
                                if (subChoiceItems.size() == 1) {
                                    content = String.valueOf(content) + "\n\tshowButton(\"" + ((Map)subChoiceItems.get(0)).get("label") + "\")";
                                    content = String.valueOf(content) + "\n\tblock = \"" + (String)((Map)((Map)((List)((Map)subChoiceItems.get(0)).get("commands")).get(0)).get("goto")).get("target") + "\"";
                                } else {
                                    content = String.valueOf(content) + "\n\tdef values" + n + "=[]";
                                    content = String.valueOf(content) + "\n\tdef pages" + n + "=[]";
                                    for (Map subSubItem : subChoiceItems) {
                                        content = String.valueOf(content) + "\n\tvalues" + n + ".add(\"" + (String)subSubItem.get("label") + "\")";
                                        content = String.valueOf(content) + "\n\tpages" + n + ".add(\"" + (String)((Map)((Map)((List)subSubItem.get("commands")).get(0)).get("goto")).get("target") + "\")";
                                    }
                                    content = String.valueOf(content) + "\n\tblock = pages" + n + "[getSelectedValue(null, values" + n + ")]";
                                }
                                goneSomewhere = true;
                                anyPause = true;
                            }
                            if (elemMap.containsKey("nyx.timer")) {
                                Map subItem4 = (Map)elemMap.get("nyx.timer");
                                delayIsSecret = subItem4.containsKey("style") && ((String)subItem4.get("style")).equals("secret");
                                String delaySrc = ((String)subItem4.get("duration")).trim();
                                if (!delaySrc.contains("-")) {
                                    delayDurationStr = String.valueOf(this.getSecondsFromString(delaySrc));
                                } else {
                                    String[] limitsSrc = delaySrc.split("-");
                                    float[] limits = new float[2];
                                    int i = 0;
                                    while (i < 2) {
                                        limits[i] = this.getSecondsFromString(limitsSrc[i]);
                                        ++i;
                                    }
                                    delayDurationStr = String.valueOf(limits[0]) + "+getRandom(" + (limits[1] - limits[0]) + ")";
                                }
                                anyPause = true;
                            }
                        }
                    }
                }
                if (hasDelay && !delayWasUsed && blockAfterDelayStr != null) {
                    content = delayIsSecret ? String.valueOf(content) + "\n\twait(" + delayDurationStr + ")" : String.valueOf(content) + "\n\twaitWithGauge(" + delayDurationStr + ")";
                    content = String.valueOf(content) + "\n\t" + blockAfterDelayStr;
                    goneSomewhere = true;
                    anyPause = true;
                }
                if (text == null || anyPause) continue;
                if (writeDelays && mp3 == null) {
                    content = String.valueOf(content) + "\n\twait(" + (2 + text.length() / 18) + ")";
                }
                if (writeDelays) continue;
                content = String.valueOf(content) + "\n\tshowButton(\"Continue\")";
            }
            if (!goneSomewhere) {
                content = String.valueOf(content) + "\n\tendReached = true";
            }
            if (mp3 != null && !mp3.equals("")) {
                content = String.valueOf(content) + "\n\tplayBackgroundSound(null);";
            }
            content = String.valueOf(content) + "\n\t}(); break\n\n";
            if (startBlock.equals("")) {
                startBlock = pageName;
            }
            ++n;
        }
        editor.setCursor(new Cursor(0));
        if (firstColor != null && Integer.parseInt(firstColor, 16) % 256 > 127) {
            editor.addInfo("OK, you should set a dark background in setInfo() ");
        } else {
            editor.addInfo("OK");
        }
        return "\n\n// Milovana - " + url + "\n// " + textSource.getString("milovana.rights", new Object[0]) + "\n" + "def endReached = false\n" + "def block = \"" + startBlock + "\"\n" + "def newBlock = block\n" + "while(!endReached && newBlock!=null) {\n" + "block = null\n" + "switch(newBlock) {\n" + content + "default:\n" + "\tshow(\"Unfinished ? (\"+newBlock+\")\")\n" + "\tendReached = true\n} // end switch \n" + "newBlock = block\n" + "} // end while \n" + "wait(1)\nshowButton(\"Close\")\nshow(\"\")\n";
    }

    private float getSecondsFromString(String str) {
        float v = 0.0f;
        if (str.contains("h")) {
            v += (float)(3600 * Integer.parseInt(str.substring(0, str.indexOf("h"))));
            if (!str.endsWith("h")) {
                str = str.substring(str.indexOf("h") + 1);
            }
        }
        if (str.contains("m") && (str.indexOf("m") == str.length() - 1 || str.charAt(str.indexOf("m") + 1) != 's')) {
            v += (float)(60 * Integer.parseInt(str.substring(0, str.indexOf("m"))));
            if (!str.endsWith("m")) {
                str = str.substring(str.indexOf("m") + 1);
            }
        }
        if (str.contains("s") && str.charAt(str.indexOf("s") - 1) != 'm') {
            v += Float.parseFloat(str.substring(0, str.indexOf("s")));
            if (!str.endsWith("s")) {
                str = str.substring(str.indexOf("s") + 1);
            }
        }
        if (str.contains("ms")) {
            v += Float.parseFloat(str.substring(0, str.indexOf("ms"))) / 1000.0f;
            if (!str.endsWith("ms")) {
                str = str.substring(str.indexOf("ms") + 1);
            }
        }
        return v;
    }

    private String getDownloadedFile(String folder, int n, Set<String> files, String url, EditorFrame editor) throws FileNotFoundException, IOException, MalformedURLException {
        String filename = url;
        if (filename.contains("?")) {
            filename = filename.substring(0, url.indexOf("?"));
        }
        if ((filename = filename.substring(filename.lastIndexOf("/") + 1)).contains("name=")) {
            filename = filename.substring(filename.indexOf("name=") + 5);
        }
        if (filename.contains("*")) {
            return this.getDownloadedFileMultiple(folder, files, url, filename);
        }
        return this.getDownloadedFileSingle(folder, n, files, url, filename, editor);
    }

    private String getDownloadedFileSingle(String folder, int n, Set<String> files, String url, String filename, EditorFrame editor) throws FileNotFoundException, IOException, MalformedURLException {
        filename = String.valueOf((n + 1) * 10) + "-" + filename;
        File f = new File(folder);
        f.mkdirs();
        f = new File(f, filename);
        if (f.exists()) {
            return filename;
        }
        FileOutputStream os = new FileOutputStream(f);
        HttpURLConnection connection = editor.getHttpURLConnection(url);
        InputStream is = connection.getInputStream();
        int c = 0;
        while ((c = is.read()) > -1) {
            ((OutputStream)os).write(c);
        }
        is.close();
        ((OutputStream)os).close();
        String foundDuplicate = null;
        for (String i : files) {
            if (new File(String.valueOf(folder) + i).length() != f.length()) continue;
            foundDuplicate = i;
        }
        if (foundDuplicate == null) {
            files.add(filename);
        } else {
            f.delete();
            filename = foundDuplicate;
        }
        return filename;
    }

    private String getDownloadedFileMultiple(String folder, Set<String> files, String url, String filename) throws FileNotFoundException, IOException, MalformedURLException {
        filename = filename.replace("*", "_").replace(".", "*.");
        while (filename.lastIndexOf("*") != filename.indexOf("*")) {
            filename = filename.replaceFirst("\\*", "");
        }
        int i = 0;
        while (i < 6) {
            File f = new File(folder);
            f.mkdirs();
            f = new File(f, filename.replace("*", String.valueOf(i)));
            if (f.exists()) {
                if (Math.random() < 0.1) {
                    // empty if block
                }
            } else {
                FileOutputStream os = new FileOutputStream(f);
                HttpURLConnection connection = this.editor.getHttpURLConnection(url);
                InputStream is = connection.getInputStream();
                int c = 0;
                while ((c = is.read()) > -1) {
                    ((OutputStream)os).write(c);
                }
                is.close();
                ((OutputStream)os).close();
            }
            ++i;
        }
        return filename;
    }
}

