/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import ss.TextSource;
import ss.desktop.EditorFrame;
import ss.desktop.Importator;

public class PictureGalleryImportator
extends Importator {
    private static final int PICTURE_MIN_HEIGHT = 320;
    private static final int PICTURE_MIN_WIDTH = 320;
    private static final int PICTURE_GALLERY_DELAY = 30;

    @Override
    public String doImport(TextSource textSource, EditorFrame editor) {
        int withDelay;
        String rootUrl;
        String dirUrl;
        String url;
        String res;
        block46: {
            block45: {
                res = "";
                String clipboardUrl = editor.getClipboardUrl();
                url = JOptionPane.showInputDialog(textSource.getString("milovana.url", new Object[0]), (Object)clipboardUrl);
                if (url != null) break block45;
                return null;
            }
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            if ((dirUrl = url).contains("?")) {
                dirUrl = dirUrl.substring(0, dirUrl.indexOf("?"));
            }
            if ((rootUrl = (dirUrl = dirUrl.substring(0, dirUrl.lastIndexOf("/")))).substring(8).contains("/")) {
                rootUrl = rootUrl.substring(0, 8 + rootUrl.substring(8).indexOf("/"));
            }
            if ((withDelay = JOptionPane.showConfirmDialog(editor, textSource.getString("milovana.delay", new Object[0]))) != 2) break block46;
            return null;
        }
        try {
            String fullUrl;
            boolean writeDelays = withDelay == 0;
            res = String.valueOf(res) + "\n\n// Picture Gallery - " + url + "\n// " + textSource.getString("milovana.rights", new Object[0]);
            JOptionPane.showMessageDialog(editor, textSource.getString("milovana.please_wait", new Object[0]));
            editor.setCursor(new Cursor(3));
            int id = 0;
            MessageDigest msgDigest = MessageDigest.getInstance("MD5");
            msgDigest.update(url.getBytes());
            int i = 0;
            while (i < 4) {
                id = (id << 8) + msgDigest.digest()[i];
                ++i;
            }
            id = Math.abs(id);
            String imageFolder = "gallery/" + id + "/";
            File f = new File("images/" + imageFolder);
            f.mkdirs();
            ArrayList<String> imageUrls = new ArrayList<String>();
            editor.addInfo(url);
            String html = editor.getUrlContent(url);
            String txtBasePattern = "<base\\s[^>]*href\\s*=\\s*(\"([^\"]+)\")|('([^']+)')";
            Pattern basePattern = Pattern.compile(txtBasePattern, 2);
            Matcher baseMatcher = basePattern.matcher(html);
            String baseUrl = dirUrl;
            if (baseMatcher.find()) {
                if (baseMatcher.group(2) != null) {
                    baseUrl = baseMatcher.group(2);
                } else if (baseMatcher.group(4) != null) {
                    baseUrl = baseMatcher.group(4);
                }
                if (dirUrl.endsWith("/")) {
                    baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
                }
            }
            String txtPattern = "<a\\s[^>]*href\\s*=\\s*((\"([^\"]+\\.jpe?g)\")|('([^']+\\.jpe?g)')|([^>]+\\.jpe?g))[^>]*>\\s*<img[^>]*>";
            Pattern pattern = Pattern.compile(txtPattern, 2);
            Matcher matcher = pattern.matcher(html);
            while (matcher.find()) {
                if (matcher.group(3) != null) {
                    imageUrls.add(matcher.group(3));
                    continue;
                }
                if (matcher.group(5) != null) {
                    imageUrls.add(matcher.group(5));
                    continue;
                }
                imageUrls.add(matcher.group(6));
            }
            ArrayList<String> alreadyDownloadedUrls = new ArrayList<String>();
            if (imageUrls.size() < 3) {
                String txtPattern2 = "<a\\s[^>]*href\\s*=\\s*((\"([^\"]+\\d[^\"]*)\"[^>]*>)|('([^']+\\d[^']*)'[^>]*>)|(([^>]*\\d[^>\\s]*)(\\s[^\\s>]*)*>))\\s*<img[^>]*>";
                Pattern pattern2 = Pattern.compile(txtPattern2, 2);
                Matcher matcher2 = pattern2.matcher(html);
                ArrayList<String> pageUrls = new ArrayList<String>();
                while (matcher2.find()) {
                    if (matcher2.group(3) != null) {
                        pageUrls.add(matcher2.group(3));
                        continue;
                    }
                    if (matcher2.group(5) != null) {
                        pageUrls.add(matcher2.group(5));
                        continue;
                    }
                    pageUrls.add(matcher2.group(7));
                }
                if (pageUrls.size() >= 3) {
                    imageUrls = new ArrayList();
                    for (String pageUrl : pageUrls) {
                        if (pageUrl.contains("://") && !pageUrl.contains(rootUrl)) continue;
                        fullUrl = pageUrl;
                        if (!pageUrl.contains("://")) {
                            fullUrl = pageUrl.startsWith("/") ? String.valueOf(rootUrl) + fullUrl : String.valueOf(baseUrl) + "/" + fullUrl;
                        }
                        if (alreadyDownloadedUrls.contains(fullUrl)) continue;
                        alreadyDownloadedUrls.add(fullUrl);
                        try {
                            String html2 = editor.getUrlContent(fullUrl);
                            baseMatcher = basePattern.matcher(html);
                            String baseUrl2 = dirUrl;
                            if (baseMatcher.find()) {
                                if (baseMatcher.group(2) != null) {
                                    baseUrl2 = baseMatcher.group(2);
                                } else if (baseMatcher.group(4) != null) {
                                    baseUrl2 = baseMatcher.group(4);
                                }
                                if (dirUrl.endsWith("/")) {
                                    baseUrl2 = baseUrl2.substring(0, baseUrl2.length() - 1);
                                }
                            }
                            Pattern patternAllImg = Pattern.compile("<img\\s[^>]*src\\s*=\\s*((\"([^\"]+\\.jpe?g)\"[^>]*)|('([^']+\\.jpe?g)'[^>]*)|(([^>]+\\.jpe?g)(\\s[^\\s>]*)*>))", 2);
                            Matcher matcherImg = patternAllImg.matcher(html2);
                            boolean found = false;
                            while (!found && matcherImg.find()) {
                                String imgUrl = matcherImg.group(3) != null ? matcherImg.group(3) : (matcherImg.group(5) != null ? matcherImg.group(5) : matcherImg.group(7));
                                String fullUrl2 = imgUrl;
                                if (!fullUrl2.contains("://")) {
                                    fullUrl2 = fullUrl2.startsWith("/") ? String.valueOf(rootUrl) + fullUrl2 : String.valueOf(baseUrl2) + "/" + fullUrl2;
                                }
                                if (alreadyDownloadedUrls.contains(fullUrl2)) continue;
                                alreadyDownloadedUrls.add(fullUrl2);
                                try {
                                    URL imgURL = new URL(fullUrl2);
                                    URLConnection imgURLC = imgURL.openConnection();
                                    imgURLC.setRequestProperty("Referer", fullUrl);
                                    imgURLC.setRequestProperty("Cache-Control", "no-cache");
                                    imgURLC.setRequestProperty("Connection", "close");
                                    imgURLC.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1");
                                    imgURLC.setRequestProperty("Accept-Charset", "UTF-8,ISO-8859-1;q=0.7,*;q=0.3");
                                    imgURLC.setRequestProperty("Accept-Encoding", "deflate,*;q=0");
                                    imgURLC.setRequestProperty("Accept-Language", "en,en-us;q=0.7");
                                    InputStream imgURLIS = imgURL.openStream();
                                    BufferedImage bi = ImageIO.read(imgURLIS);
                                    imgURLIS.close();
                                    if (bi == null || bi.getWidth() <= 320 || bi.getHeight() <= 320) continue;
                                    imageUrls.add(imgUrl);
                                    found = true;
                                }
                                catch (Exception e) {
                                    System.err.println("Img : " + e.toString());
                                }
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Int.pg. : " + e.toString());
                        }
                    }
                }
            }
            if (imageUrls.size() < 3) {
                throw new IllegalArgumentException("Only " + imageUrls.size() + " picture(s) found, invalid gallery. " + "The import tool could probably be updated to accept this gallery, " + "or the authors protected their website, " + "please ask about it in the forum.");
            }
            int n = 0;
            HashSet<String> images = new HashSet<String>();
            for (String imageUrl : imageUrls) {
                String image = imageUrl;
                if (image.contains("/")) {
                    image = image.substring(imageUrl.lastIndexOf("/") + 1);
                }
                if (image.contains("?")) {
                    image = image.substring(0, image.indexOf("?"));
                }
                image = String.valueOf((n + 1) * 10) + "-" + image;
                f = new File("images/" + imageFolder + image);
                FileOutputStream os = new FileOutputStream(f);
                fullUrl = imageUrl;
                if (!imageUrl.contains("://")) {
                    fullUrl = imageUrl.startsWith("/") ? String.valueOf(rootUrl) + fullUrl : String.valueOf(dirUrl) + "/" + fullUrl;
                }
                InputStream is = null;
                try {
                    URL imgURL = new URL(fullUrl);
                    URLConnection imgURLC = imgURL.openConnection();
                    imgURLC.setRequestProperty("Referer", url);
                    imgURLC.setRequestProperty("Cache-Control", "no-cache");
                    imgURLC.setRequestProperty("Connection", "close");
                    imgURLC.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1");
                    imgURLC.setRequestProperty("Accept-Charset", "UTF-8,ISO-8859-1;q=0.7,*;q=0.3");
                    imgURLC.setRequestProperty("Accept-Encoding", "deflate,*;q=0");
                    imgURLC.setRequestProperty("Accept-Language", "en,en-us;q=0.7");
                    is = imgURL.openStream();
                    int c = 0;
                    while ((c = is.read()) > -1) {
                        ((OutputStream)os).write(c);
                    }
                    is.close();
                    ((OutputStream)os).close();
                    this.resizeIfNeeded(f);
                    String foundDuplicate = null;
                    for (String i2 : images) {
                        if (new File("images/" + imageFolder + i2).length() != f.length()) continue;
                        foundDuplicate = i2;
                    }
                    if (foundDuplicate == null) {
                        images.add(image);
                        res = String.valueOf(res) + "\nsetImage(\"" + imageFolder + image + "\")";
                        res = String.valueOf(res) + "\nshow(\"" + (n + 1) + "\")";
                        res = writeDelays ? String.valueOf(res) + "\nwait(30)" : String.valueOf(res) + "\nshowButton(\"Continue\")";
                        res = String.valueOf(res) + "\n";
                        ++n;
                        continue;
                    }
                    f.delete();
                }
                catch (Exception e) {
                    if (is != null) {
                        is.close();
                    }
                    if (os == null) continue;
                    ((OutputStream)os).close();
                }
            }
            res = String.valueOf(res) + "\nshow(\"Goodbye\")";
            editor.setCursor(new Cursor(0));
            editor.addInfo("OK");
            return res;
        }
        catch (Exception e) {
            editor.addInfo(textSource.getString("error", e.toString()));
            editor.setCursor(new Cursor(0));
            e.printStackTrace();
            return null;
        }
    }
}

