/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JLabel;

public class PrettyButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final double RADIUS_MLT = 0.6;
    private static final float DARK_BRIGHT_DEFAULT_RATIO = 0.15f;
    private Color color;
    private JLabel l;

    public static Color brighter(Color c, float ratio) {
        int b;
        int g;
        int r;
        if (ratio > 0.0f) {
            r = 255 - (int)((float)(255 - c.getRed()) * (1.0f - ratio));
            g = 255 - (int)((float)(255 - c.getGreen()) * (1.0f - ratio));
            b = 255 - (int)((float)(255 - c.getBlue()) * (1.0f - ratio));
        } else {
            r = (int)((float)c.getRed() * (1.0f + ratio));
            g = (int)((float)c.getGreen() * (1.0f + ratio));
            b = (int)((float)c.getBlue() * (1.0f + ratio));
        }
        return new Color(r, g, b);
    }

    public static Color brighter(Color c) {
        return PrettyButton.brighter(c, 0.15f);
    }

    public static Color darker(Color c, float ratio) {
        return PrettyButton.brighter(c, -ratio);
    }

    public static Color darker(Color c) {
        return PrettyButton.brighter(c, -0.15f);
    }

    public PrettyButton(String text, Color color) {
        super(text);
        this.setColor(color);
        this.l = new JLabel();
        this.l.setVisible(false);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Color cDown;
        Color cLow;
        Color cUp;
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.getModel().isPressed()) {
            cUp = PrettyButton.darker(this.color);
            cLow = PrettyButton.brighter(this.color, 0.08f);
            cDown = PrettyButton.brighter(this.color);
        } else if (this.getModel().isRollover()) {
            cUp = PrettyButton.brighter(this.color, 0.25f);
            cLow = PrettyButton.brighter(this.color, 0.02f);
            cDown = PrettyButton.darker(this.color, 0.05f);
        } else {
            cUp = PrettyButton.brighter(this.color, 0.2f);
            cLow = PrettyButton.darker(this.color, 0.08f);
            cDown = PrettyButton.darker(this.color);
        }
        if (!this.hasFocus()) {
            cUp = PrettyButton.darker(cUp, 0.2f);
            cLow = PrettyButton.darker(cLow);
            cDown = PrettyButton.darker(cDown);
        }
        g.setPaint(new GradientPaint(10.0f, 0.0f, cUp, 10.0f, this.getHeight(), cDown));
        int radius = (int)((double)this.getHeight() * 0.6);
        g.fillRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, radius, radius);
        g.setPaint(cLow);
        int x = 4;
        while (x < this.getWidth() - 4) {
            g.fillRect(x, this.getHeight() - 2 - ((x ^ 5) * 17 + (x ^ 0x15) * 11 + (x ^ 0xA) * 7 + (x ^ 3) * 5 + x * x) % 9, 1, 1);
            ++x;
        }
        this.l.setFont(this.getFont());
        this.l.setText(this.getText());
        Dimension d = this.l.getPreferredSize();
        g.translate(this.getWidth() / 2 - d.width / 2, 0);
        this.l.setSize(d.width, this.getHeight());
        if (this.darkMean()) {
            this.l.setForeground(PrettyButton.brighter(cUp, 0.7f));
        } else {
            this.l.setForeground(PrettyButton.darker(cUp, 0.7f));
        }
        this.l.paint(g);
        g.translate(-this.getWidth() / 2 + d.width / 2, 0);
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.darkMean()) {
            g.setColor(PrettyButton.brighter(this.color, 0.3f));
        } else {
            g.setColor(PrettyButton.darker(this.color, 0.3f));
        }
        g.setStroke(new BasicStroke(1.0f));
        int radius = (int)((double)this.getHeight() * 0.6);
        g.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, radius, radius);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private boolean darkMean() {
        return this.color.getRed() + this.color.getGreen() + this.color.getBlue() < 381;
    }
}

