/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import ss.ScriptContainer;
import ss.WebCommunicator;
import ss.desktop.EditorFrame;
import ss.desktop.MainFrame;

public class Publisher {
    private static final String SAVE_RESOURCE_LIST_CODE = "Save this list !";
    private static final String SPECIAL_CODE_TO_AVOID_TIME_UPDATE = "maintenance release";
    private EditorFrame editorFrame;
    private MainFrame main;

    public Publisher(EditorFrame editorFrame, MainFrame main) {
        this.editorFrame = editorFrame;
        this.main = main;
    }

    public void execute() {
        ScriptContainer sc = this.main.getScriptContainer();
        String text = sc.currentScriptText;
        List<String> fileNames = this.getWantedFiles(text);
        if (fileNames == null || fileNames.size() == 0) {
            return;
        }
        if (fileNames.get(fileNames.size() - 1).equals(SAVE_RESOURCE_LIST_CODE)) {
            fileNames.remove(fileNames.size() - 1);
            text = String.valueOf(text) + "\n/*\n * Resources";
            try {
                String currentFolder = new File("").getCanonicalPath();
                for (String fileName : fileNames) {
                    if ((fileName = fileName.replace(currentFolder, "").replace("\\", "/")).startsWith("/")) {
                        fileName = fileName.substring(1);
                    }
                    if (fileName.startsWith("./")) {
                        fileName = fileName.substring(2);
                    }
                    text = String.valueOf(text) + "\n * " + fileName;
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.editorFrame, this.main.getString("error", ex.toString()));
                ex.printStackTrace();
            }
            sc.currentScriptText = text = String.valueOf(text) + "\n */";
            this.editorFrame.setText(text);
            this.main.writeScript(sc.currentScriptFileName, true);
        }
        this.editorFrame.addInfo("...");
        this.editorFrame.setCursor(new Cursor(3));
        try {
            this.doPublish(fileNames, text.contains(SPECIAL_CODE_TO_AVOID_TIME_UPDATE));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.editorFrame, this.main.getString("error", ex.toString()));
            ex.printStackTrace();
        }
        this.editorFrame.setCursor(new Cursor(0));
    }

    private List<String> getWantedFiles(String text) {
        boolean inResources = false;
        boolean hasResources = false;
        boolean hasCleanedResources = false;
        ScriptContainer sc = this.main.getScriptContainer();
        String[] stringArray = text.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern;
            Object matcher;
            String s = stringArray[n2];
            if (s.matches("^\\s*\\*\\s*$")) {
                inResources = false;
            }
            if (inResources && s.matches("^\\s*\\*\\s*.+$") && ((Matcher)(matcher = (pattern = Pattern.compile("^\\s*\\*\\s*([^\\s].+[^\\s])\\s*$")).matcher(s))).find()) {
                sc.addToMainUsedFiles(((Matcher)matcher).group(1));
            }
            if (s.matches("^\\s*\\*\\s*Resources\\s*$")) {
                inResources = true;
                hasResources = true;
                if (!hasCleanedResources) {
                    sc.clearUsedFiles();
                    hasCleanedResources = true;
                }
            }
            ++n2;
        }
        if (sc.savedAuthor == null || sc.currentScriptFileName == null) {
            JOptionPane.showMessageDialog(this.editorFrame, this.main.getString("publish.please_run", new Object[0]));
            return null;
        }
        if (sc.savedTitle.equals("")) {
            JOptionPane.showMessageDialog(this.editorFrame, this.main.getString("error", "(title)"));
            return null;
        }
        JOptionPane op = new JOptionPane(this.main.getString("publish.files_intro", sc.savedTitle), 3, 2);
        JDialog dialog = op.createDialog(this.main.getString("title", new Object[0]));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JTextArea ta = new JTextArea();
        ta.setColumns(110);
        ta.setRows(12);
        ta.setAutoscrolls(true);
        for (String s : sc.getUsedFiles()) {
            ta.setText(String.valueOf(ta.getText()) + s + "\n");
        }
        JScrollPane scrollPane = new JScrollPane(ta);
        panel.add(scrollPane);
        scrollPane.setAlignmentX(0.5f);
        JCheckBox addResourcesCheckbox = new JCheckBox(this.main.getString("publish.save_resource_list", new Object[0]));
        if (hasResources) {
            addResourcesCheckbox.setEnabled(false);
        }
        panel.add(addResourcesCheckbox);
        addResourcesCheckbox.setAlignmentX(0.5f);
        panel.add(op);
        op.setAlignmentX(0.5f);
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(2);
        if ((Integer)op.getValue() == 0) {
            ArrayList<String> res = new ArrayList<String>(Arrays.asList(ta.getText().split("\n")));
            if (addResourcesCheckbox.isSelected()) {
                res.add(SAVE_RESOURCE_LIST_CODE);
            }
            return res;
        }
        return null;
    }

    private void addToZipStream(String fileName, List<String> precedingZipEntries, ZipOutputStream zos) throws IOException {
        int len;
        String baseDir = new File("").getCanonicalPath();
        String zipName = fileName.substring(baseDir.length() + 1);
        if (precedingZipEntries.contains((zipName = zipName.replace("\\", "/").trim()).trim())) {
            return;
        }
        String dirsPath = "";
        String[] dirs = zipName.split("/");
        String[] stringArray = dirs = Arrays.copyOfRange(dirs, 0, dirs.length - 1);
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            if (!precedingZipEntries.contains((dirsPath = String.valueOf(dirsPath) + dir + "/").trim())) {
                zos.putNextEntry(new ZipEntry(dirsPath));
                precedingZipEntries.add(dirsPath);
            }
            ++n2;
        }
        zos.putNextEntry(new ZipEntry(zipName));
        byte[] buf = new byte[16384];
        FileInputStream fis = new FileInputStream(fileName);
        while ((len = fis.read(buf)) > 0) {
            zos.write(buf, 0, len);
        }
        fis.close();
        zos.closeEntry();
    }

    private void addPathToZipStream(String pathName, List<String> precedingZipEntries, ZipOutputStream zos) throws IOException {
        File dir;
        String newName = pathName;
        String baseDir = new File("").getCanonicalPath();
        if (!pathName.contains(baseDir)) {
            newName = String.valueOf(baseDir) + "/" + "scripts/" + new File(pathName).getName();
        }
        if ((dir = new File(newName).getParentFile()).getPath().contains("*")) {
            throw new IOException("\"*\" not allowed in directory names");
        }
        if (newName.contains("*")) {
            File[] fileList = dir.listFiles(new FileFilter(){
                private String newName;

                @Override
                public boolean accept(File pathName) {
                    String regexp = this.newName.replace("\\", "\\\\").replace(".", "\\.").replace("*", ".*");
                    return !pathName.isDirectory() && !pathName.isHidden() && pathName.getPath().matches(regexp);
                }

                public FileFilter init(String newName) {
                    this.newName = newName;
                    return this;
                }
            }.init(newName));
            if (fileList != null) {
                File[] fileArray = fileList;
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.addToZipStream(f.getCanonicalPath(), precedingZipEntries, zos);
                    ++n2;
                }
            }
        } else {
            this.addToZipStream(newName, precedingZipEntries, zos);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doPublish(List<String> fileNames, boolean isMaintenanceRelease) throws IOException {
        block13: {
            block14: {
                byos = new ByteArrayOutputStream();
                zos = new ZipOutputStream(byos);
                zos.setLevel(-1);
                Collections.sort(fileNames);
                precedingZipEntries = new ArrayList<String>();
                for (String s : fileNames) {
                    if (s.length() <= 5) continue;
                    this.addPathToZipStream(s, precedingZipEntries, zos);
                }
                zos.flush();
                zos.close();
                byos.close();
                timeStr = String.valueOf(new Date().getTime() / 1000L);
                sc = this.main.getScriptContainer();
                localDir = new File(".", "published");
                localDir.mkdirs();
                zipName = new File(sc.currentScriptFileName).getName();
                zipName = zipName.substring(0, zipName.lastIndexOf("."));
                zipName = String.valueOf(zipName) + "_" + timeStr + ".zip";
                localZipFile = new File(localDir, zipName);
                fos = new FileOutputStream(localZipFile);
                fos.write(byos.toByteArray(), 0, byos.size());
                fos.close();
                System.out.println(localZipFile.getCanonicalPath());
                encodedString = "";
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"version\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + String.valueOf(sc.savedVersion);
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"title\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + sc.savedTitle;
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"summary\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + sc.savedSummary;
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"author\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + sc.savedAuthor;
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"status\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + sc.savedStatus;
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"color\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + String.valueOf(sc.savedColor);
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"lang\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + sc.savedLang;
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                tags = "";
                sep = "";
                for (String tag : sc.savedTags) {
                    tags = String.valueOf(tags) + sep + tag;
                    sep = ",";
                }
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"tags\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + tags;
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"time\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                encodedString = String.valueOf(encodedString) + timeStr;
                encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                if (isMaintenanceRelease) {
                    encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"maintenance\"\n";
                    encodedString = String.valueOf(encodedString) + "Content-Type: text/plain; charset=UTF-8\n\n";
                    encodedString = String.valueOf(encodedString) + "on";
                    encodedString = String.valueOf(encodedString) + "\n--BoBoBoBo\n";
                }
                encodedString = String.valueOf(encodedString) + "Content-Disposition: form-data; name=\"file\"; filename=\"" + new File(sc.currentScriptFileName).getName() + "\"\n";
                encodedString = String.valueOf(encodedString) + "Content-Transfert-encoding: binary\n";
                encodedString = String.valueOf(encodedString) + "Content-Type: binary/zip\n\n";
                conn = new WebCommunicator().getConnection("https://ss.deviatenow.com/scripts.php");
                try {
                    block12: {
                        conn.setDoInput(true);
                        conn.setDoOutput(true);
                        conn.setRequestMethod("POST");
                        conn.setReadTimeout(120000);
                        conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=BoBoBoBo");
                        conn.setRequestProperty("Accept-Encoding", "deflate");
                        os = conn.getOutputStream();
                        pw = new PrintWriter((Writer)new OutputStreamWriter(os, "utf-8"), true);
                        pw.write(encodedString);
                        pw.flush();
                        os.write(byos.toByteArray(), 0, byos.size());
                        os.flush();
                        pw.write("\n--BoBoBoBo--\n");
                        pw.flush();
                        buffer = new byte[1024];
                        is = conn.getInputStream();
                        is.read(buffer, 0, 1024);
                        allResponse = "";
                        try {
                            try {
                                allResponse = new String(buffer);
                            }
                            catch (Exception var21_26) {
                                is.close();
                                break block12;
                            }
                        }
                        catch (Throwable var22_27) {
                            is.close();
                            throw var22_27;
                        }
                        is.close();
                    }
                    if (!allResponse.startsWith("ok")) {
                        throw new Exception("Perhaps error publishing : " + allResponse);
                    }
                    JOptionPane.showMessageDialog(this.editorFrame, this.main.getString("publish.ok", new Object[0]));
                    break block13;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    eis = conn.getErrorStream();
                    errorMessage = "";
                    if (eis == null) break block14;
                    erd = new BufferedReader(new InputStreamReader(eis));
                    ** while ((line = erd.readLine()) != null)
                }
lbl-1000:
                // 1 sources

                {
                    errorMessage = String.valueOf(errorMessage) + line;
                    continue;
                }
            }
            JOptionPane.showMessageDialog(this.editorFrame, this.main.getString("error", new Object[]{String.valueOf(e.toString()) + "\n" + errorMessage}));
        }
    }
}

