/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import com.github.sarxos.webcam.Webcam;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.swing.UIManager;
import javazoom.jl.player.Player;
import ss.IScript;
import ss.MainWindow;
import ss.PropertiesWorker;
import ss.ScriptContainer;
import ss.TextSource;
import ss.WebCommunicator;
import ss.desktop.JOptionDialog;
import ss.desktop.MainFrame;

public class Script
implements IScript {
    private static final int SOUND_BUFFER_SIZE = 4096;
    public static final int WAIT_SOUND_THREAD_MS = 46;
    private static final int SYNC_DELAY_MS = 200;
    private static final String[] IMAGE_EXTENSIONS = new String[]{"gif", "png", "bmp", "jpeg", "jpg"};
    private static final String CAPTURED_IMAGE_FOLDER = "captured/";
    private static final String RECEIVED_IMAGE_FOLDER = "received/";
    private static final int WEBCAM_IDEAL_WIDTH = 800;
    protected MainWindow mainWindow;
    protected TextSource textSource;
    private List<Thread> soundThreads;
    private List<SourceDataLine> soundLines;
    private boolean shouldStopSoundThreads;
    private WebCommunicator webCommunicator;
    private Map<String, byte[]> buffers;

    public Script(MainWindow mainWindow, TextSource textSource) {
        this.mainWindow = mainWindow;
        this.textSource = textSource;
        this.soundThreads = new ArrayList<Thread>();
        this.soundLines = new ArrayList<SourceDataLine>();
        this.shouldStopSoundThreads = false;
        this.webCommunicator = new WebCommunicator();
        ScriptContainer sc = mainWindow.getScriptContainer();
        if (mainWindow != null) {
            sc.clearUsedFiles();
        }
        this.buffers = new HashMap<String, byte[]>();
        if (mainWindow != null && sc.currentScriptFileName != null) {
            this.addToMainUsedFiles(sc.currentScriptFileName);
        }
    }

    public Script(MainWindow mainWindow, TextSource textSource, long seed) {
        throw new RuntimeException("Not implemented");
    }

    public void finalize() {
        this.stopSoundThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopSoundThreads() {
        this.shouldStopSoundThreads = true;
        List<Object> list = this.soundLines;
        synchronized (list) {
            for (SourceDataLine sd : this.soundLines) {
                sd.close();
            }
            this.soundLines.clear();
        }
        try {
            Thread.sleep(46L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        list = this.soundThreads;
        synchronized (list) {
            for (Thread t : this.soundThreads) {
                if (!t.isAlive()) continue;
                t.stop();
            }
        }
        for (Thread t : this.soundThreads) {
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        list = this.soundThreads;
        synchronized (list) {
            this.soundThreads.clear();
        }
        this.shouldStopSoundThreads = false;
        this.mainWindow.setPlayingSound(false);
    }

    @Override
    public void setInfos(int version, String title, String summary, String author, String status, int color, String lang, List<String> tags) {
        this.mainWindow.changeColor(color);
        this.mainWindow.setTitle(title);
        this.mainWindow.getScriptContainer().update(version, title, summary, author, status, color, lang, tags);
        if (version > 9) {
            this.mainWindow.showMessage(this.textSource.getString("error.version", version, 9), true);
        }
    }

    @Override
    public void show(Object s) {
        String text2 = null;
        if (s != null) {
            text2 = String.valueOf(s);
        }
        this.mainWindow.showFromScript(text2);
    }

    @Override
    public double showButton(Object s, double duration) {
        try {
            return this.mainWindow.showButtonFromScript(String.valueOf(s), duration);
        }
        catch (InterruptedException e) {
            return 0.0;
        }
    }

    @Override
    public double showButton(Object s) {
        return this.showButton(s, 2592000.0);
    }

    @Override
    public float showPopup(Object text) {
        String text2 = null;
        if (text != null) {
            text2 = String.valueOf(text);
        }
        return this.mainWindow.showPopupFromScript(text2);
    }

    @Override
    public String getString(Object text, Object defaultValue) {
        String text2 = null;
        if (text != null) {
            text2 = String.valueOf(text);
        }
        try {
            return this.mainWindow.getStringFromScript(text2, String.valueOf(defaultValue));
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public Integer getInteger(Object text, Integer defaultValue) {
        Integer res = null;
        do {
            String defaultValue2 = null;
            if (defaultValue != null) {
                defaultValue2 = String.valueOf(defaultValue);
            }
            String textRes = this.getString(text, defaultValue2);
            try {
                res = new Integer(textRes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (res == null);
        return res;
    }

    @Override
    public Float getFloat(Object text, Float defaultValue) {
        Float res = null;
        do {
            String defaultValue2 = null;
            if (defaultValue != null) {
                defaultValue2 = String.valueOf(defaultValue);
            }
            String textRes = this.getString(text, defaultValue2);
            try {
                res = new Float(textRes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (res == null);
        return res;
    }

    @Override
    public boolean getBoolean(Object text, Object yesMessage, Object noMessage) {
        String text2 = null;
        if (text != null) {
            text2 = String.valueOf(text);
        }
        try {
            return this.mainWindow.getBooleanFromScript(text2, String.valueOf(yesMessage), String.valueOf(noMessage));
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean getBoolean(Object text) {
        return this.getBoolean(text, UIManager.get("OptionPane.yesButtonText"), UIManager.get("OptionPane.noButtonText"));
    }

    @Override
    public int getSelectedValue(Object text, List<String> values) {
        String text2 = null;
        if (text != null) {
            text2 = String.valueOf(text);
        }
        try {
            return this.mainWindow.getSelectedValueFromScript(text2, values);
        }
        catch (InterruptedException e) {
            return 0;
        }
    }

    @Override
    public List<Boolean> getBooleans(Object title, List<String> values, List<Boolean> defaultValues) {
        GraphicsDevice device;
        String title2 = null;
        if (title != null) {
            title2 = String.valueOf(title);
        }
        if ((device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()).getFullScreenWindow() == this.mainWindow) {
            device.setFullScreenWindow(null);
        }
        JOptionDialog jod = new JOptionDialog((MainFrame)this.mainWindow, this.textSource.getString("title", new Object[0]), title2, values, defaultValues);
        return jod.getModalResult();
    }

    @Override
    public int getRandom(Integer max) {
        if (max == null) {
            max = 100;
        }
        return (int)(Math.random() * (double)max.intValue());
    }

    public int getRandom(double max) {
        return this.getRandom(new Integer((int)max));
    }

    @Override
    public void replacedByWait(double duration) {
        try {
            this.mainWindow.waitFromScript(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void waitWithGauge(double duration) {
        try {
            this.mainWindow.waitWithGaugeFromScript(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public String getDataFolder() {
        String s = String.valueOf(this.mainWindow.getDataFolder().getAbsolutePath()) + "/";
        if (s.endsWith("./")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    @Override
    public int getTime() {
        return (int)Math.round((double)System.currentTimeMillis() / 1000.0);
    }

    @Override
    public String getImage(Object message) {
        Webcam webcam = null;
        try {
            Integer webcamIndex = this.mainWindow.getPropertiesWorker().loadInteger("application.webcam.index");
            webcam = webcamIndex != null && webcamIndex > -1 ? (Webcam)Webcam.getWebcams((long)5000L).get(webcamIndex) : Webcam.getDefault((long)5000L);
            if (webcam == null) {
                String string = this.getFile(message);
                return string;
            }
            Dimension[] viewSizes = webcam.getViewSizes();
            int minDiff = 100000;
            Dimension best = null;
            Dimension[] dimensionArray = viewSizes;
            int n = viewSizes.length;
            int n2 = 0;
            while (n2 < n) {
                Dimension viewSize = dimensionArray[n2];
                int diff = Math.abs(viewSize.width - 800);
                if (diff < minDiff) {
                    minDiff = diff;
                    best = viewSize;
                }
                ++n2;
            }
            webcam.setViewSize(best);
            webcam.open();
            String filename = String.valueOf((int)(Math.random() * 2.147483647E9)) + ".jpeg";
            File fullfile = new File("images/captured/", filename);
            new File("images/captured/").mkdirs();
            ImageIO.write((RenderedImage)webcam.getImage(), "JPEG", fullfile);
            if (fullfile.exists()) {
                String string = fullfile.getCanonicalPath();
                return string;
            }
            return null;
        }
        catch (Exception e) {
            String string = this.getFile(message);
            return string;
        }
        finally {
            if (webcam != null && webcam.isOpen()) {
                webcam.close();
            }
        }
    }

    @Override
    public String getFile(Object message) {
        File srcFile = this.mainWindow.getFileFromChooser(false, null, String.valueOf(message), null);
        if (srcFile != null) {
            try {
                return srcFile.getCanonicalPath();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String loadString(String key) {
        return this.mainWindow.getPropertiesWorker().loadString(key);
    }

    @Override
    public Integer loadInteger(String key) {
        return this.mainWindow.getPropertiesWorker().loadInteger(key);
    }

    @Override
    public Float loadFloat(String key) {
        return this.mainWindow.getPropertiesWorker().loadFloat(key);
    }

    @Override
    public Boolean loadBoolean(String key) {
        return this.mainWindow.getPropertiesWorker().loadBoolean(key);
    }

    @Override
    public String loadFirstTrue(String ... keys) {
        return this.mainWindow.getPropertiesWorker().loadFirstTrue(keys);
    }

    @Override
    public Map<String, ?> loadMap(String key) {
        return (Map)this.load(key);
    }

    @Override
    public Object load(String key) {
        return this.mainWindow.getPropertiesWorker().load(key);
    }

    @Override
    public void save(String key, Object v) {
        this.mainWindow.getPropertiesWorker().save(key, v);
    }

    @Override
    public void setImage(String fileName) {
        try {
            if (fileName == null || fileName.trim().isEmpty()) {
                this.mainWindow.setImageFromScript((String)null);
            } else {
                File f;
                if (fileName.startsWith("/") || fileName.contains(":")) {
                    f = new File(fileName);
                } else {
                    f = new File(this.mainWindow.getDataFolder(), "videos/" + fileName);
                    if (!f.exists()) {
                        f = new File(this.mainWindow.getDataFolder(), "images/" + fileName);
                    }
                }
                if (!f.exists()) {
                    this.showPopup(this.textSource.getString("missing", f.getPath()));
                } else {
                    this.addToMainUsedFiles(f.getPath());
                    String extension = f.getPath().substring(f.getPath().lastIndexOf(".") + 1);
                    if (Arrays.asList(IMAGE_EXTENSIONS).contains(extension)) {
                        this.mainWindow.setImageFromScript(f.getPath());
                    } else if (Arrays.asList("mpg", "mpeg", "avi", "asf", "h264", "rv", "mov", "wmf", "3gp").contains(extension)) {
                        this.useFile(f.getCanonicalPath());
                    }
                }
            }
        }
        catch (Exception e) {
            this.showPopup(this.textSource.getString("error", e.toString()));
        }
    }

    @Override
    public void setImage(byte[] bytes, int useless) {
        this.mainWindow.setImageFromScript(bytes);
    }

    public void setImage(Image image, boolean unu) {
        ScriptContainer sc = this.mainWindow.getScriptContainer();
        if (sc.savedVersion > 4) {
            throw new RuntimeException("Deprecated");
        }
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        int type = 2;
        BufferedImage bi = new BufferedImage(width, height, type);
        Graphics2D g2d = bi.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bi, "png", baos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mainWindow.setImageFromScript(baos.toByteArray());
    }

    @Override
    public void useFile(String fileName) {
        File f = new File(fileName);
        boolean succeed = false;
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.open(f);
                succeed = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!succeed) {
            String command = f.getAbsolutePath();
            String osname = System.getProperty("os.name").toLowerCase();
            if (osname.contains("windows 9")) {
                command = "command.com /C start \"\" \"" + f.getAbsolutePath() + "\"";
            } else if (osname.contains("windows")) {
                command = "cmd /C start \"\" \"" + f.getAbsolutePath() + "\"";
            } else if (osname.contains("mac")) {
                command = "open '" + f.getAbsolutePath() + "'";
            } else if (osname.contains("linux")) {
                command = "xdg-open '" + f.getAbsolutePath() + "'";
            }
            try {
                Process p = Runtime.getRuntime().exec(command);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int exitValue = 0;
                try {
                    exitValue = p.exitValue();
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                if (exitValue != 0) {
                    String errorStr = "";
                    BufferedReader br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                    while (br.ready()) {
                        errorStr = String.valueOf(errorStr) + br.readLine();
                    }
                    br.close();
                    br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    while (br.ready()) {
                        errorStr = String.valueOf(errorStr) + br.readLine();
                    }
                    br.close();
                    this.showPopup(String.valueOf(fileName) + " could not be open.\nThe command was : " + command + ", the exit value " + exitValue + " and the error was :\n " + errorStr);
                }
                succeed = true;
            }
            catch (IOException e) {
                this.showPopup(this.textSource.getString("error", String.valueOf(command) + " " + e.toString()));
            }
        }
    }

    @Override
    public void useUrl(String url) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(url));
        }
        catch (Exception e) {
            this.showPopup(this.textSource.getString("error", String.valueOf(url) + " " + e.toString()));
        }
    }

    @Override
    public void useEmailAddress(String address) {
        Desktop desktop = Desktop.getDesktop();
        try {
            if (desktop.isSupported(Desktop.Action.MAIL)) {
                if (!address.startsWith("mailto:")) {
                    address = "mailto:" + address;
                }
                desktop.mail(new URI(address));
            } else {
                this.show("(no mail client configured ; send a mail to " + address + ")");
            }
        }
        catch (Exception e) {
            this.showPopup(this.textSource.getString("error", String.valueOf(address) + " " + e.toString()));
        }
    }

    @Override
    public void playSound(String fileName) {
        if (fileName == null) {
            this.stopSoundThreads();
            return;
        }
        if (fileName.toLowerCase().endsWith("mp3")) {
            this.playMp3Sound(fileName);
        } else {
            this.playWavSound(fileName);
        }
    }

    @Override
    public void playBackgroundSound(String fileName) {
        this.playBackgroundSound(fileName, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playBackgroundSound(String fileName, int times) {
        if (fileName == null) {
            this.stopSoundThreads();
            return;
        }
        if (!this.loadInMemory(fileName)) {
            return;
        }
        Thread t = new Thread(){
            private String fileName;
            private int times;

            public Thread init(String fileName, int times) {
                this.fileName = fileName;
                this.times = times;
                return this;
            }

            @Override
            public void run() {
                int i = 0;
                while (i < this.times && !Script.this.shouldStopSoundThreads) {
                    Script.this.playSound(this.fileName);
                    ++i;
                }
            }
        }.init(fileName, times);
        List<Thread> list = this.soundThreads;
        synchronized (list) {
            this.soundThreads.add(t);
        }
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playWavSound(String fileName) {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.loadInMemory(fileName)) {
                return;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.buffers.get(fileName));
            AudioInputStream ais = AudioSystem.getAudioInputStream(is);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, ais.getFormat());
            SourceDataLine dl = (SourceDataLine)AudioSystem.getLine(info);
            List<SourceDataLine> list = this.soundLines;
            synchronized (list) {
                this.soundLines.add(dl);
            }
            dl.open(ais.getFormat());
            this.mainWindow.setPlayingSound(true);
            dl.start();
            long elapsed = System.currentTimeMillis() - startTime;
            int bytesPerSeconds = (int)((float)ais.getFormat().getFrameSize() * ais.getFormat().getFrameRate());
            byte[] buf = new byte[4096];
            Arrays.fill(buf, (byte)0);
            if (elapsed < 200L) {
                int i = 0;
                while (!this.shouldStopSoundThreads && (long)i < (200L - elapsed) * (long)bytesPerSeconds / 1000L / 4096L) {
                    dl.write(buf, 0, 4096);
                    ++i;
                }
            }
            int n = 0;
            while (!this.shouldStopSoundThreads && (n = ais.read(buf)) > -1) {
                dl.write(buf, 0, n);
            }
            dl.drain();
            dl.close();
            List<SourceDataLine> list2 = this.soundLines;
            synchronized (list2) {
                this.soundLines.remove(dl);
            }
            ais.close();
            this.updatePlayingSound(Thread.currentThread());
        }
        catch (Exception e) {
            this.showPopup(this.textSource.getString("error", e.toString()));
        }
    }

    private void playMp3Sound(String fileName) {
        Player player = null;
        try {
            if (!this.loadInMemory(fileName)) {
                return;
            }
            try {
                long startTime = System.currentTimeMillis();
                ByteArrayInputStream is = new ByteArrayInputStream(this.buffers.get(fileName));
                player = new Player((InputStream)is);
                this.mainWindow.setPlayingSound(true);
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed < 200L) {
                    Thread.sleep(200L - elapsed);
                }
                player.play();
            }
            catch (Exception e) {
                this.showPopup(this.textSource.getString("error", e.toString()));
            }
        }
        finally {
            if (player != null) {
                player.close();
            }
            this.updatePlayingSound(Thread.currentThread());
        }
    }

    @Override
    public void openCdTrays() {
        String osname = System.getProperty("os.name").toLowerCase();
        try {
            if (osname.contains("windows")) {
                File file = File.createTempFile("sexscriptscd", ".vbs");
                file.deleteOnExit();
                FileWriter fw = new FileWriter(file);
                String vbs = "Set oWMP = CreateObject(\"WMPlayer.OCX\")\nSet colCDROMs = oWMP.cdromCollection\nFor d = 0 to colCDROMs.Count - 1\ncolCDROMs.Item(d).Eject\nNext\nset owmp = nothing\nset colCDROMs = nothing\nwscript.Quit(0)";
                fw.write(vbs);
                fw.close();
                Runtime.getRuntime().exec("wscript " + file.getPath()).waitFor();
            } else if (osname.contains("mac")) {
                Runtime.getRuntime().exec("drutil tray eject");
            } else {
                Runtime.getRuntime().exec("eject");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean loadInMemory(String fileName) {
        if (this.buffers.containsKey(fileName)) {
            return true;
        }
        File f = fileName.startsWith("/") || fileName.contains(":") ? new File(fileName) : new File(this.mainWindow.getDataFolder(), "sounds/" + fileName);
        if (!f.exists()) {
            this.showPopup(this.textSource.getString("missing", f.getPath()));
            return false;
        }
        try {
            int n2;
            FileInputStream is = new FileInputStream(f);
            byte[] bs = new byte[(int)f.length() + 1024];
            int n = 0;
            while ((n2 = is.read(bs, n, 1024)) > -1) {
                n += n2;
            }
            is.close();
            this.buffers.put(fileName, bs);
            this.addToMainUsedFiles(f.getPath());
            return true;
        }
        catch (Exception e) {
            this.showPopup(this.textSource.getString("missing", f.getPath()));
            return false;
        }
    }

    @Override
    public void exit() {
        this.mainWindow.dispose();
        Thread.currentThread().stop();
    }

    @Override
    public boolean isConnected() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("action", "test");
        try {
            String s = this.webCommunicator.send(data, null).trim();
            return s.equals("ok");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public void send(String key, Object value) {
        Map<Object, Object> props;
        if (key.length() > 1000) {
            throw new InvalidParameterException("Key " + key.substring(0, 10) + "... too long");
        }
        if (value != null) {
            String valueStr = String.valueOf(value);
            if (valueStr.length() > 10000) {
                throw new InvalidParameterException("Value " + valueStr.substring(0, 10) + "... too long");
            }
            props = PropertiesWorker.getPropertiesListFromObjectRec(key, value);
        } else {
            props = new HashMap();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("action", "ssca_send_mlt");
        data.put("basekey", key);
        for (String string : props.keySet()) {
            data.put("data[" + string + "]", (String)props.get(string));
        }
        try {
            System.out.println(this.webCommunicator.send(data, null));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public Boolean receiveBoolean(String key) {
        try {
            return (Boolean)this.receive(key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Float receiveFloat(String key) {
        try {
            return (Float)this.receive(key);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public Integer receiveInteger(String key) {
        try {
            return (Integer)this.receive(key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, ?> receiveMap(String key) {
        return (Map)this.receive(key);
    }

    @Override
    public String receiveString(String key) {
        Object o = this.receive(key);
        if (o == null) {
            return null;
        }
        return String.valueOf(o);
    }

    @Override
    public Object receive(String key) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("action", "ssca_receive_mlt");
        data.put("key", key);
        try {
            String s = this.webCommunicator.send(data, null);
            Properties props = new Properties();
            props.load(new StringReader(s));
            if (props.containsKey("error")) {
                throw new InvalidParameterException("Key " + key + " : " + props.getProperty("error"));
            }
            return PropertiesWorker.getObjectFromPropertiesListRec(key, props);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public String sendImage(String filename) {
        if (!new File(filename).exists()) {
            return null;
        }
        String ext = filename.substring(filename.lastIndexOf(".") + 1);
        if (!Arrays.asList(IMAGE_EXTENSIONS).contains(ext.toLowerCase())) {
            return null;
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("action", "ssca_sendimage");
        ArrayList<String> files = new ArrayList<String>();
        files.add(filename);
        try {
            String res = this.webCommunicator.send(data, files);
            if (res.startsWith("Ok")) {
                return res.substring(res.indexOf(32) + 1).split(",")[0].trim();
            }
            return null;
        }
        catch (IOException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public String receiveImage(String code) {
        block5: {
            String ext = code.substring(code.lastIndexOf(".") + 1);
            if (!Arrays.asList(IMAGE_EXTENSIONS).contains(ext.toLowerCase())) {
                return null;
            }
            if (new File("images/received/" + code).exists()) {
                return RECEIVED_IMAGE_FOLDER + code;
            }
            try {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("action", "ssca_receiveimage");
                data.put("code", code);
                new File("images/received/").mkdirs();
                if (this.webCommunicator.sendAndSaveToFile(data, null, "images/received/" + code) >= 10) break block5;
                return null;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return RECEIVED_IMAGE_FOLDER + code;
    }

    @Override
    public String run() {
        return null;
    }

    private void addToMainUsedFiles(String fileName) {
        this.mainWindow.getScriptContainer().addToMainUsedFiles(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlayingSound(Thread closingThread) {
        boolean playingSound = false;
        List<Thread> list = this.soundThreads;
        synchronized (list) {
            if (this.soundThreads != null) {
                for (Thread t : this.soundThreads) {
                    if (!t.isAlive() || t == closingThread) continue;
                    playingSound = true;
                }
            }
        }
        this.mainWindow.setPlayingSound(playingSound);
    }
}

