/*
 * Decompiled with CFR 0.152.
 */
package ss.desktop;

import java.awt.Image;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import ss.IScript;
import ss.MainWindow;
import ss.ScriptContainer;
import ss.TextSource;

public class ScriptStub
implements IScript {
    private static final int EXTREME_DURATION_S = 2592000;
    private MainWindow mainWindow;
    private TextSource textSource;
    private Random random;
    private int statDelay;
    private int state;

    public ScriptStub(MainWindow mainWindow, TextSource textSource) {
        throw new RuntimeException("Not implemented");
    }

    public ScriptStub(MainWindow mainWindow, TextSource textSource, long seed) {
        this.mainWindow = mainWindow;
        this.textSource = textSource;
        this.random = new Random(seed);
        this.statDelay = 0;
        this.state = 0;
    }

    @Override
    public void setInfos(int version, String title, String summary, String author, String status, int color, String lang, List<String> tags) {
        this.state = 1;
        this.mainWindow.getScriptContainer().update(version, title, summary, author, status, color, lang, tags);
        if (version > 9) {
            this.mainWindow.showMessage(this.textSource.getString("error.version", version, 9), true);
        }
    }

    @Override
    public void show(Object s) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
    }

    @Override
    public double showButton(Object s, double duration) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        double realDuration = duration > 2591999.9 && duration < 2592000.1 ? (double)this.getRndSeconds() : (this.random.nextInt(2) == 0 ? duration : duration * this.random.nextDouble());
        this.statDelay = (int)((double)this.statDelay + realDuration);
        return realDuration;
    }

    @Override
    public double showButton(Object s) {
        return this.showButton(s, 2592000.0);
    }

    @Override
    public float showPopup(Object s) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        float realDuration = this.getRndSeconds();
        this.statDelay = (int)((float)this.statDelay + realDuration);
        return realDuration;
    }

    @Override
    public String getDataFolder() {
        String s = String.valueOf(this.mainWindow.getDataFolder().getAbsolutePath()) + "/";
        if (s.endsWith("./")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    @Override
    public String getString(Object text, Object defaultValue) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        String s = "";
        int i = 0;
        while (i < this.random.nextInt(10)) {
            s = String.valueOf(s) + (char)(this.random.nextInt(26) + 65);
            ++i;
        }
        this.statDelay += 15;
        return s;
    }

    @Override
    public Integer getInteger(Object text, Integer defaultValue) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += this.getRndSeconds();
        if (this.random.nextInt(2) == 0) {
            return defaultValue;
        }
        return this.random.nextInt(10) * this.random.nextInt(10);
    }

    @Override
    public Float getFloat(Object text, Float defaultValue) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += this.getRndSeconds();
        if (this.random.nextInt(2) == 0) {
            return defaultValue;
        }
        return Float.valueOf(this.random.nextFloat() * (float)this.random.nextInt(10) * (float)this.random.nextInt(10));
    }

    @Override
    public boolean getBoolean(Object text, Object yesMessage, Object noMessage) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += 5;
        return this.random.nextInt(2) == 0;
    }

    @Override
    public boolean getBoolean(Object text) {
        return this.getBoolean(text, "", "");
    }

    @Override
    public int getSelectedValue(Object text, List<String> values) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += 5 + values.size() / 2;
        return this.random.nextInt(values.size());
    }

    @Override
    public List<Boolean> getBooleans(Object title, List<String> values, List<Boolean> defaultValues) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += 1 + values.size() * 2;
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        int i = 0;
        while (i < values.size()) {
            res.add(this.random.nextInt(2) == 0);
            ++i;
        }
        return res;
    }

    @Override
    public int getRandom(Integer max) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        if (max == null) {
            max = 100;
        }
        return this.random.nextInt(max);
    }

    public int getRandom(double max) {
        return this.getRandom(new Integer((int)max));
    }

    @Override
    public void replacedByWait(double duration) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay = (int)((double)this.statDelay + duration);
    }

    @Override
    public void waitWithGauge(double duration) {
        this.replacedByWait(duration);
    }

    @Override
    public int getTime() {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        return (int)Math.round((double)(System.currentTimeMillis() + (long)TimeZone.getDefault().getOffset(System.currentTimeMillis())) / 1000.0) + this.random.nextInt(10000);
    }

    @Override
    public String getImage(Object message) {
        return this.getFile(message);
    }

    @Override
    public String getFile(Object message) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += 20;
        if (this.random.nextInt(2) == 0) {
            return null;
        }
        return this.getString(null, "x.jpg");
    }

    @Override
    public String loadString(String key) {
        this.state = 2;
        if (this.random.nextInt(2) == 0) {
            return this.getString(null, "xyz");
        }
        return this.mainWindow.getPropertiesWorker().loadString(key);
    }

    @Override
    public Integer loadInteger(String key) {
        this.state = 2;
        if (this.random.nextInt(2) == 0) {
            return this.getInteger(null, 1);
        }
        return this.mainWindow.getPropertiesWorker().loadInteger(key);
    }

    @Override
    public Float loadFloat(String key) {
        this.state = 2;
        if (this.random.nextInt(2) == 0) {
            return this.getFloat(null, Float.valueOf(1.0f));
        }
        return this.mainWindow.getPropertiesWorker().loadFloat(key);
    }

    @Override
    public Boolean loadBoolean(String key) {
        this.state = 2;
        if (this.random.nextInt(2) == 0) {
            return this.getBoolean(null);
        }
        return this.mainWindow.getPropertiesWorker().loadBoolean(key);
    }

    @Override
    public Map<String, ?> loadMap(String key) {
        this.state = 2;
        if (this.random.nextInt(2) == 0) {
            return null;
        }
        return this.mainWindow.getPropertiesWorker().loadMap(key);
    }

    @Override
    public Object load(String key) {
        this.state = 2;
        if (this.random.nextInt(2) == 0) {
            return null;
        }
        return this.mainWindow.getPropertiesWorker().load(key);
    }

    @Override
    public String loadFirstTrue(String ... keys) {
        this.state = 2;
        if (this.random.nextInt(2) == 0) {
            int n = this.random.nextInt(keys.length + 1);
            if (n == keys.length) {
                return null;
            }
            return keys[n];
        }
        return this.mainWindow.getPropertiesWorker().loadFirstTrue(keys);
    }

    @Override
    public void save(String key, Object v) {
        this.state = 2;
        this.mainWindow.getPropertiesWorker().save(key, v);
    }

    @Override
    public void setImage(String fileName) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        if (fileName != null && !fileName.trim().isEmpty()) {
            if (fileName.startsWith("/") || fileName.contains(":")) {
                File f = new File(fileName);
            } else {
                File f = new File(this.mainWindow.getDataFolder(), "videos/" + fileName);
                if (!f.exists()) {
                    f = new File(this.mainWindow.getDataFolder(), "images/" + fileName);
                }
                if (f.exists()) {
                    this.addToMainUsedFiles(f.getPath());
                    File dir = f.getParentFile();
                    File superDir = dir.getParentFile();
                    try {
                        String dirFile;
                        String fPath = f.getPath().replace("\\", "/");
                        String fLowerCasePath = f.getPath().replace("\\", "/").toLowerCase();
                        String[] stringArray = dir.list();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            dirFile = stringArray[n2];
                            if (!fPath.contains("/" + dirFile) && fLowerCasePath.contains("/" + dirFile.toLowerCase())) {
                                throw new UnsupportedOperationException("Image path problem (" + fileName + "), probable cause is case sensitivity.");
                            }
                            ++n2;
                        }
                        stringArray = superDir.list();
                        n = stringArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            dirFile = stringArray[n2];
                            if (!fPath.contains("/" + dirFile + "/") && fLowerCasePath.contains("/" + dirFile.toLowerCase() + "/")) {
                                throw new UnsupportedOperationException("Image path problem (" + fileName + "), probable cause is case sensitivity.");
                            }
                            ++n2;
                        }
                    }
                    catch (UnsupportedOperationException ex) {
                        throw ex;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @Override
    public void setImage(byte[] bytes, int unu) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
    }

    public void setImage(Image image, boolean unu) {
        ScriptContainer sc = this.mainWindow.getScriptContainer();
        if (sc.savedVersion > 4) {
            throw new RuntimeException("Deprecated");
        }
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
    }

    @Override
    public void useFile(String fileName) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.addToMainUsedFiles(fileName);
        this.statDelay += 15;
    }

    @Override
    public void useUrl(String url) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += 60;
    }

    @Override
    public void useEmailAddress(String address) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += 60;
    }

    @Override
    public void playSound(String fileName) {
        this.playBackgroundSound(fileName);
        if (fileName != null) {
            this.statDelay += 3;
        }
    }

    @Override
    public void playBackgroundSound(String fileName) {
        this.playBackgroundSound(fileName, 1);
    }

    @Override
    public void playBackgroundSound(String fileName, int times) {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        if (fileName != null) {
            File f = new File(this.mainWindow.getDataFolder(), "sounds/" + fileName);
            this.addToMainUsedFiles(f.getPath());
        }
    }

    @Override
    public void openCdTrays() {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
        this.statDelay += 5;
    }

    @Override
    public void exit() {
        if (this.state == 0) {
            throw new UnsupportedOperationException("setInfo() must be called before everything else.");
        }
        this.state = 2;
    }

    @Override
    public boolean isConnected() {
        return this.random.nextInt(2) == 0;
    }

    @Override
    public Boolean receiveBoolean(String key) {
        ++this.statDelay;
        return this.loadBoolean(key);
    }

    @Override
    public Float receiveFloat(String key) {
        ++this.statDelay;
        return this.loadFloat(key);
    }

    @Override
    public String receiveImage(String code) {
        this.statDelay += 5;
        return "";
    }

    @Override
    public Integer receiveInteger(String key) {
        ++this.statDelay;
        return this.loadInteger(key);
    }

    @Override
    public Map<String, ?> receiveMap(String key) throws InterruptedException {
        this.statDelay += 5;
        return this.loadMap(key);
    }

    @Override
    public String receiveString(String key) {
        ++this.statDelay;
        return this.loadString(key);
    }

    @Override
    public Object receive(String key) {
        ++this.statDelay;
        return this.load(key);
    }

    @Override
    public void send(String key, Object value) {
        ++this.statDelay;
    }

    @Override
    public String sendImage(String filename) {
        this.statDelay += 20;
        return "abcdefgh";
    }

    public int getStatDelay() {
        return Math.max(0, this.statDelay);
    }

    @Override
    public void stopSoundThreads() {
    }

    @Override
    public String run() {
        return null;
    }

    private int getRndSeconds() {
        return (int)(1.0 + Math.pow(this.random.nextDouble(), 6.0) * (double)(2 + this.statDelay / 2));
    }

    private void addToMainUsedFiles(String fileName) {
        this.mainWindow.getScriptContainer().addToMainUsedFiles(fileName);
    }
}

