/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.util;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MjpegInputStream
extends DataInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(MjpegInputStream.class);
    private final byte[] SOI_MARKER = new byte[]{-1, -40};
    private final byte[] EOI_MARKER = new byte[]{-1, -39};
    private final String CONTENT_LENGTH = "Content-Length".toLowerCase();
    private static final int HEADER_MAX_LENGTH = 100;
    private static final int FRAME_MAX_LENGTH = 100100;
    private boolean open = true;

    public MjpegInputStream(InputStream in) {
        super(new BufferedInputStream(in, 100100));
    }

    private int getEndOfSeqeunce(DataInputStream in, byte[] sequence) throws IOException {
        int s = 0;
        for (int i = 0; i < 100100; ++i) {
            byte c = (byte)in.readUnsignedByte();
            if (c == sequence[s]) {
                if (++s != sequence.length) continue;
                return i + 1;
            }
            s = 0;
        }
        return -1;
    }

    private int getStartOfSequence(DataInputStream in, byte[] sequence) throws IOException {
        int end = this.getEndOfSeqeunce(in, sequence);
        return end < 0 ? -1 : end - sequence.length;
    }

    private int parseContentLength(byte[] headerBytes) throws IOException, NumberFormatException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(headerBytes);
             InputStreamReader isr = new InputStreamReader(bais);
             BufferedReader br = new BufferedReader(isr);){
            String line = null;
            while (true) {
                if ((line = br.readLine()) != null) {
                    if (!line.toLowerCase().startsWith(this.CONTENT_LENGTH)) continue;
                    String[] parts = line.split(":");
                    if (parts.length != 2) continue;
                    int n = Integer.parseInt(parts[1].trim());
                    return n;
                    continue;
                }
                break;
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage readFrame() throws IOException {
        if (!this.open) {
            return null;
        }
        this.mark(100100);
        int n = this.getStartOfSequence(this, this.SOI_MARKER);
        this.reset();
        byte[] header = new byte[n];
        this.readFully(header);
        int length = -1;
        try {
            length = this.parseContentLength(header);
        }
        catch (NumberFormatException e) {
            length = this.getEndOfSeqeunce(this, this.EOI_MARKER);
        }
        if (length == 0) {
            LOG.error("Invalid MJPEG stream, EOI (0xFF,0xD9) not found!");
        }
        this.reset();
        byte[] frame = new byte[length];
        this.skipBytes(n);
        this.readFully(frame);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(frame);){
            BufferedImage bufferedImage = ImageIO.read(bais);
            return bufferedImage;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.open = false;
        }
    }

    public boolean isClosed() {
        return !this.open;
    }
}

