setInfos(1, "Font configuration", "Script lauched to choose an alternative font", 
	"Doti", "complete", 0xEEEEBB, "en", ["options"]);

def language = Locale.getDefault().getLanguage()
def currentFont = loadString("application.font")
def firstText = "Your language code detected : \""+language+"\""
if(currentFont!=null)
	firstText += "\n\nYou chose previously : "+currentFont
firstText += "\n\n"+
		"Here are some special characters for your information (thanks to Colombia Univ.), using your current font:\n"+
			"Various : ¥£€\$¢₡₢₣₤₥₦₧₨₩₪₫₭₮₯\n"+
		"- Greek : Τη γλώσσα μου έδωσαν ελληνική\n"+
		"- Russian : На берегу пустынных волн\n"+
		"- Chinese : 我能吞下玻璃而不伤身体。\n"+
		"- Chinese (Traditional) : 我能吞下玻璃而不傷身體。\n"+
		"- Arabic : أنا قادر على أكل الزجاج و هذا لا يؤلمني.\n"+
		"- Sanskrit : ﻿काचं शक्नोम्यत्तुम् । नोपहिनस्ति माम् ॥ काचं शक्नोम्यत्तुम् । नोपहिनस्ति माम्﻿काचं शक्नोम्यत्तुम् । नोपहिनस्ति माम् ﻿काचं शक्नोम्यत्तुम् । नोपहिनस्ति माम् ॥ ";
show(firstText)
showButton("Ok")

def standard = ["de","en","es","fr","it","nl"].contains(language) 
def message = ""
if(standard && currentFont==null)
	message = "This language doesn't seem to need a special font to be correctly printed. "+
		"Anyway you can choose one. "
else
	message = "You'll be able now to choose an alternative font to show texts in SexScript."

if(getBoolean(message)) {
	setImage(null)
	show("Searching...")
	wait(0.1)
	def fontNames = (List<java.lang.String>)[]
	def fontTextList = ["** Default font **"]
	// try java android
	if(fontNames.size()==0) {
		try {
			Class.forName("android.app.Activity")
			fontNames = ["Droid Sans", "Droid Serif", "Droid Sans Mono"]
			for(def font:fontNames)
				fontTextList.add(font)
		} catch(e) { }
	}
	// try java awt
	if(fontNames.size==0) {
		try {
			def geObject = Class.forName("java.awt.GraphicsEnvironment").
				getMethod("getLocalGraphicsEnvironment").
				invoke(null)
			def fontList = (List<?>)geObject.getClass().getMethod("getAllFonts").
				invoke(geObject)	
			for(def font:fontList) {
				fontNames.add(font.getFontName())
				def nbGlyphs = font.getNumGlyphs()
				def glyphText = "glyphs"
				if(nbGlyphs>=1000)
					glyphText += " !!!!!"
				if(nbGlyphs>=10000)
					glyphText += "!!!!!"
				fontTextList.add(font.getFontName()+" ("+font.getFamily() + ", "+nbGlyphs+" "+glyphText+")")
			}
		} catch(e) { 
			show("Error : "+e)			
		}
	}
	def fontN = getSelectedValue("Please choose one", fontTextList)
	if(fontN>0)
		save("application.font", fontNames[fontN-1])
	else
		save("application.font", null)
	show("SexScripts will now stop, restart it to use the choosen font")
	showButton("Ok")
	exit()
}
if(loadBoolean("intro.running")!=null && loadBoolean("intro.running")) {	
	if(getBoolean("Configure toys options ?"))		
		return "toys";
	if(getBoolean("Configure womens clothes options ?"))
		return "womensclothes";
	if(getBoolean("Configure mens clothes options ?"))
		return "mensclothes";
	show("Introduction ended, you can now use the menu to start a script (included, or downloaded from http://ss.deviatenow.com)")	
	save("intro.running", null);
}
