// Test script, this is also a (quite) full reference
// If you ever done some programming, fully reading this script should be enough
// to understand how to do scripts.
// If not, you may read "simple.groovy" script instead, more...simple.
// Ask the community on the website for any questions : "Script Writing" Forum.


// Used on website, these are some metadata about your script ; see description from
// template when creating new scripts.
// (Ss version, title, description, author, status, color, language code, tags) 
setInfos(8, "Test", "Test script (for all functions), and example for advanced writers.",
		"Doti", "complete", 0xDDDDDD, "en", ["test", "internet"]);

// ** User interactions, system
// Show this in the main window ; \n for carriage return.
show("Welcome.\nWait 2s.");

// Wait some seconds (here : 2 seconds) without doing anything. This is a pause.
wait(2);

// Ask for some info in a popup ; first is the question, then is the default value
def q = getString("What is the next question ?", "Stop now");
// 6 lines below are never used (because variable "q" won't be null)
if(q == null) {
	// Ask for an integer number
	def i = getInteger("?",0);
	// Ask for a floating number 
	def f = getFloat("?",0.0f);
}

// return the number of seconds (integer number) till 01/01/1970 ("UNIX timestamp")
def startTime = getTime();
// Ask for a boolean (yes/true or no/false)
if(getBoolean(q)==true) {
	// Wait 2 seconds, showing a small gauge
	waitWithGauge(2);
	// same thing, with custom texts
	if(getBoolean("You confirm you want to quit ?", "Yes, I do", "No I don't")) {
		//test with null value (should not show "null" !
		show("Sure ?")
		if(getBoolean(null)) {
			show("Bye");
			// Interrupt script 
			// you may use return "abc"; instead in order to launch abc.groovy after this script
			return ;
		}
	}
} else {
	def elapsed = getTime() - startTime;
	show("You answered in "+elapsed+" second(s)");
	// Show a button below the text, waiting for click (then hide this button)
	// Returns elapsed time (waiting click), in seconds (floating precision number)
	elapsed = showButton("Ok");
	show("This time in "+elapsed+" second(s)");
	showButton("Ok");
}
// Show a dialog box with a lot of checkboxes inside, to be checked or not
// Parameters : title, values, defaultValues
// Return a list of boolean (checked or not), or null if [Cancel] clicked 
def qualities = getBooleans("Is this test ?",["Blue", "Great", "Simple"], [false, true, true]);
if(qualities != null && qualities[1]==true) {
	showPopup("Of course it is !");
	if(qualities[2]==true)
		if(getSelectedValue("But which the most ?", 
				["It's Blue", "It's quite great, really", "Simple, very simple, yeah"])==1)
			show("I do agree")
}

// Second argument is optionnal : max time waited before auto click
def elapsed = showButton("Continue ...", 5)
if(elapsed==5) {
	show("You are too slow");
	wait(2)
}


// ** Saving / loading data (file data.properties)

// Load a number from disk, or null (if not found)
def n = loadInteger("test.counter"); 
// Floating decimal numbers may be read also
if(n == null)
	n = loadFloat("test.alternative_inexistant_counter");
// Simple strings may be read also
if(n == null)
	n = loadString("test.alternative_inexistant_counter2");
// Booleans (true / false)
if(n == null)
	n = loadBoolean("test.alternative_inexistant_counter3");
//Full map (key->value)
if(n == null)
	n = loadMap("test.alternative_inexistant_counter4");
//Anything 
if(n == null)
	n = load("test.alternative_inexistant_counter5");
if(n == null)
	n = 0;
// getRandom(max) returns a number between 0 and max (excluded), here : 0, 1 or 2 
n = n + 1 + getRandom(3);
show("You launched this test less than "+n+" times");

wait(2)
//save data ; warning, you may erase another value of the same key (here "test.counter")
//from another script ! A good idea is doing like below, prefixing with script name.
save("test.counter", n);
// Load a string : the first true boolean (userfull for toys, clothes...)
def toy = loadFirstTrue("toys.vibrating_dildo", "toys.dildo");
if(toy==null)
	show("No dildo ?");
else
	show("Nice, you have a dildo");

showButton("Continue ...");

// ** Multimedia

// Show image (file must be in "images/" directory, perhaps in a sub-directory)
// Extensions jpg, jpeg, png, gif are supported. null = nothing. Case-sensitive.
setImage(null);

wait(1);

// Rare : setImage(...,0) shows a picture created from nothing : more difficulties,
// as it's, alas, Android or PC specific, so this needs dynamic invocation. This
// is complex stuff.
// TODO check again if this needs dynamic invocations like below; it seems not
if(!System.getProperty("java.vm.name").contains("Dalvik")) {
	//PC (GNU/linux, OS X, Windows, etc.)
	// static, classic invocations - Don't
	/*
	def bi = new java.awt.image.BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB)
	def g2d = bi.createGraphics()
	// not : def white = new Color(255, 255, 255)
	// but :
	def white = new java.awt.Color(255, 255, 255)	
	g2d.setColor(white)
	g2d.fillRect(0, 0, 800, 600)
	def pink = new java.awt.Color(255, 100, 100)
	g2d.setPaint(pink)
	g2d.setFont(g2d.getFont().deriveFont(50f))
	g2d.drawString("Generated PNG\n(static)", 200, 200)
	
	def output = new ByteArrayOutputStream()
	javax.imageio.ImageIO.write(bi, "png", output)
	setImage(output.toByteArray(), 0)
	*/
	
	// dynamic, runtime invocations
	def bi = Class.forName("java.awt.image.BufferedImage").
		getConstructor(int.class, int.class, int.class).
		newInstance(800, 600, 2)
	def g2d = bi.createGraphics()
	// not : def white = new Color(255, 255, 255)
	// but :
	def white = Class.forName("java.awt.Color").
		getConstructor(int.class, int.class, int.class).
		newInstance(255, 255, 255)	
	g2d.setColor(white)
	g2d.fillRect(0, 0, 800, 600)
	def pink = Class.forName("java.awt.Color").
		getConstructor(int.class, int.class, int.class).
		newInstance(255, 100, 100)
	g2d.setPaint(pink)
	g2d.setFont(g2d.getFont().deriveFont(50f))
	g2d.drawString("Generated PNG", 200, 200)
	
	def output = new ByteArrayOutputStream()
	Class.forName("javax.imageio.ImageIO").getMethod("write", 
			Class.forName("java.awt.image.RenderedImage"), String.class, OutputStream.class).
			invoke(null, bi, "png", output)
	setImage(output.toByteArray(), 0)
} else {
	//Android			
	/*
	def ARGB_8888 = android.graphics.Bitmap.Config.ARGB_8888
	def bmp = android.graphics.Bitmap.createBitmap(null,800, 600, ARGB_8888)
	def canvas = new android.graphics.Canvas(bmp)
	def white = new android.graphics.Paint()
	white.setColor(android.graphics.Color.rgb(255, 255, 255))
	white.setStyle(android.graphics.Paint.Style.FILL)
	canvas.drawPaint(white)
	def pink = new android.graphics.Paint()
	pink.setColor(android.graphics.Color.rgb(255, 100, 100))
	pink.setStyle(android.graphics.Paint.Style.FILL_AND_STROKE)
	pink.setTextSize(50)
	canvas.drawText("Generated PNG\n(static)", 200, 200, pink)
	def output = new ByteArrayOutputStream()
	bmp.compress(android.graphics.Bitmap.CompressFormat.PNG, 100, output)
	setImage(output.toByteArray(), 0)
	*/
	
	def ARGB_8888 = Enum.valueOf(Class.forName("android.graphics.Bitmap\$Config"), "ARGB_8888")
	def bmp = Class.forName("android.graphics.Bitmap").
		getMethod("createBitmap", int.class, int.class, Class.forName("android.graphics.Bitmap\$Config")).
		invoke(null,800, 600, ARGB_8888)
	def canvas = Class.forName("android.graphics.Canvas").
		getConstructor(Class.forName("android.graphics.Bitmap")).
		newInstance(bmp)
	def white = Class.forName("android.graphics.Paint").
		getConstructor().newInstance()
	white.setColor(Class.forName("android.graphics.Color").
		getMethod("rgb", int.class, int.class, int.class).
		invoke(null,255, 255, 255))
	white.setStyle(Enum.valueOf(Class.forName("android.graphics.Paint\$Style"), "FILL"))
	canvas.drawPaint(white)
	def pink = Class.forName("android.graphics.Paint").
		getConstructor().newInstance()
	pink.setColor(Class.forName("android.graphics.Color").
		getMethod("rgb", int.class, int.class, int.class).
		invoke(null,255, 100, 100))
	pink.setStyle(Enum.valueOf(Class.forName("android.graphics.Paint\$Style"), "FILL_AND_STROKE"))
	pink.setTextSize(50)
	canvas.drawText("Generated PNG", 200, 200, pink)	
	def output = new ByteArrayOutputStream()
	bmp.compress(Enum.valueOf(Class.forName("android.graphics.Bitmap\$CompressFormat"), "PNG"), 100, output)
	setImage(output.toByteArray(), 0)
}
wait(2)
setImage(null)

if(getBoolean("Try webcam ?")) {
	// Load image path from the user harddisk, they choose it ; filename is a character string
	def filename = getImage("Please put a shot of you")
	setImage(filename)	
	show("Here is the image : "+filename)
	wait(2)
}	

show("Will now : play sounds, play video, open URL, use email and open CD trays.\n\nWatch out !")

for(def i=0;i<2;i++) {
	// Play sound (.wav file must be in "sounds/" directory, or in a sub-directory)
	// playBackgroundSound() will not wait the end of the sound
	playBackgroundSound("whip.wav");
	wait(1);
}
// playSound() will wait the end of the sound
playSound("whip.wav");

// useFile() will try to open a file with anything available on the system
useFile(getDataFolder()+"videos/test.mp4");

// true if can connect to the SexScripts server
if(isConnected()) {

	//some data : a map of a list, an integer and a string
	def website = ["urls":["https://ss.deviatenow.com", "http://ss.deviatenow.com"], "founded":2011, "name":"SexScripts"];

	//send() sends some data - like save(), but in a common remote server
	send("test.website", website);
	
	//receive() (and receiveBoolean(), receiveString()... reads this data back)
	//receive() reads all kind of data (string, boolean, number, list, map, map of list, list of map...)
	//save(), receive(), and their variants, are also explored in the script "the worst picture"
	def readBackWebsite = receive("test.website");

	// useUrl() will try to open an browser with the URL
	useUrl(readBackWebsite["urls"][0]);
}

//useEmailAddress() will try to open an email adress with any tool associated. Doesn't auto-send.
useEmailAddress("marylin@example.org");

//openCdTrays() will open all cd trays or vibrate
openCdTrays();

setImage("door.jpg");
showPopup("This test is now over");

// This script, from http://ss.deviatenow.com, is protected by this licence : 
// CC by-NC, see http://creativecommons.org/licenses/by-nc/3.0/

/*
 * If you put a block like this (begining with "Resources"), publication will be easier :
 *
 * Resources
 * scripts/test.groovy
 * sounds/whip.wav
 * videos/*.mpg
 * images/*.jp*g
 */
